/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.standalone;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.standalone.FileHandle;

public class ProjectHandle
extends FileHandle
implements AbstractProjectHandle {
    private Map<String, FileHandle> handles = new HashMap<String, FileHandle>();
    private String registryName = ".settings/org.eclipse.qvt.declarative.modelregistry";
    private String rootPath = null;

    public ProjectHandle(String projectFile, String registryPath) throws IOException {
        this(new File(projectFile), registryPath);
        this.handles.put(this.getFile().toString(), this);
    }

    public ProjectHandle(File projectFile, String registryPath) throws IOException {
        super(projectFile);
        this.setRegistryName(registryPath);
        this.handles.put(this.getFile().toString(), this);
    }

    public FileHandle getFileHandle(String name) throws IOException {
        File referenceFile = this.getFile();
        if (name.startsWith("/")) {
            name = name.substring(1);
            referenceFile = this.rootPath == null ? new File(referenceFile.getParent()) : new File(this.rootPath);
        }
        File memberFile = new File(referenceFile, name);
        return this.getFileHandle(memberFile);
    }

    public FileHandle getFileHandle(File file) throws IOException {
        if (file == null) {
            return null;
        }
        String canonicalFileName = ProjectHandle.createCanonicalFileName(file);
        FileHandle handle = this.handles.get(canonicalFileName);
        if (handle == null) {
            handle = new FileHandle(this, file);
            this.handles.put(handle.getFile().toString(), handle);
        }
        return handle;
    }

    public FileHandle getParentFileHandle() {
        return null;
    }

    public File getRegistryFile() {
        return new File(this.file, this.getRegistryName());
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public URI getRegistryURI() {
        URI registryURI = URI.createURI((String)this.registryName);
        URI projectURI = this.getURI();
        URI resolvedURI = registryURI.resolve(projectURI);
        return resolvedURI;
    }

    public String getRoot() {
        return this.rootPath;
    }

    public URI getURI() {
        return URI.createFileURI((String)(String.valueOf(this.getFile().toString()) + "/"));
    }

    public void refreshRegistry() {
    }

    public void setRegistryName(String name) {
        this.registryName = name != null ? name : ".settings/org.eclipse.qvt.declarative.modelregistry";
    }

    public void setRoot(String rootPath) {
        this.rootPath = rootPath;
    }
}

