/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.model;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;

public class URIAccessor
implements Accessor {
    public static final String KIND = "URI";
    private final URI uri;

    private static URI createPrototypeURI() {
        try {
            return new URI("/prototype/");
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URIAccessor() {
        this(URIAccessor.createPrototypeURI());
    }

    public URIAccessor(URI uri) {
        this.uri = uri;
    }

    public boolean equals(Object object) {
        if (!(object instanceof URIAccessor)) {
            return false;
        }
        return this.uri.equals(((URIAccessor)object).getURI());
    }

    public String getKind() {
        return KIND;
    }

    public String getName() {
        return this.uri.toString();
    }

    public URI getURI() {
        return this.uri;
    }

    public URIAccessor newInstance(String name) throws URISyntaxException {
        return new URIAccessor(new URI(name));
    }

    public String toString() {
        return this.getName();
    }
}

