/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.mappings;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.qvt.declarative.ecore.mappings.AbstractFeatureElement;
import org.eclipse.qvt.declarative.ecore.mappings.ExtensionFeatureElement;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EStructuralFeatureMap<FE extends EStructuralFeature> {
    protected final IMappingMetaDataRegistry.Install mappingMetaDataRegistry;
    protected final AbstractFeatureElement<FE> ecoreFeatureElement;
    protected final AbstractFeatureElement<? extends EStructuralFeature> adaptingFeatureElement;

    protected EStructuralFeatureMap(IMappingMetaDataRegistry.Install mappingMetaDataRegistry, AbstractFeatureElement<FE> ecoreEStructuralFeature, AbstractFeatureElement<? extends EStructuralFeature> adaptingEStructuralFeature) {
        this.mappingMetaDataRegistry = mappingMetaDataRegistry;
        this.ecoreFeatureElement = ecoreEStructuralFeature;
        this.adaptingFeatureElement = adaptingEStructuralFeature;
        if (ecoreEStructuralFeature != null) {
            // empty if block
        }
        if (ecoreEStructuralFeature != null) assert (!ecoreEStructuralFeature.isContainer()) : "should not create isContainer EStructuralFeatureMap for " + MappingUtils.formatFeatureName(ecoreEStructuralFeature);
        if (adaptingEStructuralFeature != null) assert (!adaptingEStructuralFeature.isContainer()) : "should not create isContainer EStructuralFeatureMap for " + MappingUtils.formatFeatureName(adaptingEStructuralFeature);
    }

    public void exportFeature(EObject ecoreObject, EObject adaptingObject) {
        if (this.ecoreFeatureElement == null || this.adaptingFeatureElement == null) {
            return;
        }
        Object ecoreValue = this.getEcoreValue(ecoreObject, false);
        Object adaptingValue = this.exportValueOrValues(adaptingObject, ecoreValue);
        if (adaptingValue != null) {
            this.setAdaptingValue(adaptingObject, adaptingValue);
        }
    }

    protected abstract Object exportValue(EObject var1, Object var2);

    public Object exportValueOrValues(EObject adaptingObject, Object ecoreValue) {
        if (ecoreValue instanceof List) {
            return this.exportValues(adaptingObject, (List)ecoreValue);
        }
        return this.exportValue(adaptingObject, ecoreValue);
    }

    protected abstract List<?> exportValues(EObject var1, List<?> var2);

    public EStructuralFeature getAdaptingFeature() {
        return this.adaptingFeatureElement != null ? this.adaptingFeatureElement.getEStructuralFeature() : null;
    }

    public AbstractFeatureElement<? extends EStructuralFeature> getAdaptingFeatureElement() {
        return this.adaptingFeatureElement;
    }

    public Object getAdaptingValue(EObject adaptingContainerObject, EObject adaptingObject) {
        if (this.adaptingFeatureElement == null) {
            return null;
        }
        if (adaptingObject instanceof AnyType) {
            return this.adaptingFeatureElement.getExtension(this.mappingMetaDataRegistry, adaptingContainerObject, (AnyType)adaptingObject);
        }
        return this.adaptingFeatureElement.get(this.mappingMetaDataRegistry, adaptingObject, false);
    }

    public AbstractFeatureElement<FE> getEcoreFeatureElement() {
        return this.ecoreFeatureElement;
    }

    public FE getEcoreStructuralFeature() {
        return this.ecoreFeatureElement != null ? (FE)this.ecoreFeatureElement.getEStructuralFeature() : null;
    }

    public Object getEcoreValue(EObject ecoreObject, boolean resolveProxies) {
        return this.ecoreFeatureElement != null ? this.ecoreFeatureElement.get(this.mappingMetaDataRegistry, ecoreObject, resolveProxies) : null;
    }

    public void importFeature(EObject adaptingContainerObject, EObject adaptingObject, EObject ecoreObject) {
        if (this.ecoreFeatureElement == null || this.adaptingFeatureElement == null) {
            return;
        }
        Object adaptingValue = this.getAdaptingValue(adaptingContainerObject, adaptingObject);
        Object ecoreValue = this.importValueOrValues(adaptingContainerObject.eResource(), adaptingObject, adaptingValue);
        if (ecoreValue != null) {
            this.setEcoreValue(ecoreObject, ecoreValue);
        }
    }

    protected abstract Object importValue(Resource var1, EObject var2, Object var3);

    public Object importValueOrValues(Resource adaptingResource, EObject adaptingObject, Object adaptingValue) {
        if (adaptingValue instanceof FeatureMap) {
            FeatureMap featureMap = (FeatureMap)adaptingValue;
            if (featureMap.size() != 1) {
                return this.importValues(adaptingResource, adaptingObject, (List<?>)featureMap);
            }
            return this.importValue(adaptingResource, adaptingObject, featureMap.get(0));
        }
        if (adaptingValue instanceof List) {
            return this.importValues(adaptingResource, adaptingObject, (List)adaptingValue);
        }
        return this.importValue(adaptingResource, adaptingObject, adaptingValue);
    }

    protected List<Object> importValues(Resource adaptingResource, EObject adaptingObject, List<?> adaptingValues) {
        ArrayList<Object> ecoreValues = new ArrayList<Object>();
        for (Object adaptingValue : adaptingValues) {
            Object ecoreValue = this.importValue(adaptingResource, adaptingObject, adaptingValue);
            if (ecoreValue == null) continue;
            ecoreValues.add(ecoreValue);
        }
        return ecoreValues;
    }

    public void install() {
        if (this.ecoreFeatureElement != null) {
            this.installEcoreFeatureElement(this.ecoreFeatureElement);
        }
        if (this.adaptingFeatureElement != null) {
            this.installAdaptingFeatureElement(this.adaptingFeatureElement);
        }
    }

    protected void installAdaptingFeatureElement(AbstractFeatureElement<? extends EStructuralFeature> adaptingFeatureElement) {
        EStructuralFeature adaptingEStructuralFeature;
        if (!(adaptingFeatureElement instanceof ExtensionFeatureElement) && (adaptingEStructuralFeature = adaptingFeatureElement.getEStructuralFeature()) != null) {
            this.mappingMetaDataRegistry.putAdaptingFeatureMap(adaptingEStructuralFeature, this);
        }
    }

    protected void installEcoreFeatureElement(AbstractFeatureElement<FE> ecoreFeatureElement) {
        FE ecoreEStructuralFeature = ecoreFeatureElement.getEStructuralFeature();
        if (ecoreEStructuralFeature != null) {
            this.mappingMetaDataRegistry.putEcoreFeatureMap((EStructuralFeature)ecoreEStructuralFeature, this);
        }
    }

    public boolean isSetEcore(EObject ecoreObject) {
        if (this.ecoreFeatureElement == null) {
            return false;
        }
        FE ecoreEFeature = this.ecoreFeatureElement.getEStructuralFeature();
        EClass ecoreObjectEClass = ecoreObject.eClass();
        EClass ecoreEFeatureEClass = ecoreEFeature.getEContainingClass();
        if (!ecoreEFeatureEClass.isSuperTypeOf(ecoreObjectEClass)) {
            return false;
        }
        return ecoreObject.eIsSet(ecoreEFeature);
    }

    public void setAdaptingValue(EObject adaptingObject, Object adaptingValue) {
        if (adaptingObject instanceof AnyType) {
            this.adaptingFeatureElement.setExtension(this.mappingMetaDataRegistry, (AnyType)adaptingObject, adaptingValue);
        } else if (this.adaptingFeatureElement instanceof ExtensionFeatureElement) {
            this.adaptingFeatureElement.set(this.mappingMetaDataRegistry, adaptingObject, adaptingValue);
        }
    }

    public void setEcoreValue(EObject ecoreObject, Object ecoreValue) {
        assert (!(ecoreObject instanceof AnyType));
        this.ecoreFeatureElement.set(this.mappingMetaDataRegistry, ecoreObject, ecoreValue);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.ecoreFeatureElement)) + " <==> " + String.valueOf(this.adaptingFeatureElement);
    }

    public void unsetEcore(EObject ecoreObject) {
        ecoreObject.eUnset(this.ecoreFeatureElement.getEStructuralFeature());
    }
}

