/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.builder.AtlBuilderMessages;
import org.eclipse.m2m.atl.engine.AtlCompiler;
import org.eclipse.m2m.atl.engine.CompilerNotFoundException;
import org.eclipse.m2m.atl.engine.MarkerMaker;

public class AtlBuildVisitor
implements IResourceVisitor {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private MarkerMaker markerMaker = new MarkerMaker();
    private IProgressMonitor monitor;

    public AtlBuildVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private boolean hasChanged(IResource resource) {
        return resource.getLocalTimeStamp() > this.getAsmFile(resource).getLocalTimeStamp();
    }

    private boolean hasAsmFile(IResource resource) {
        return this.getAsmFile(resource).exists();
    }

    private IFile getAsmFile(IResource resource) {
        String atlFileName = resource.getName();
        String asmFileName = String.valueOf(atlFileName.substring(0, atlFileName.lastIndexOf(46))) + ".asm";
        IFile asm = resource.getParent().getFile((IPath)new Path(asmFileName));
        return asm;
    }

    public boolean visit(IResource resource) throws CoreException {
        String extension = resource.getFileExtension();
        if ("atl".equals(extension) && resource instanceof IFile && ((IFile)resource).getLocation().toFile().length() > 0L && (!this.hasAsmFile(resource) || this.hasChanged(resource))) {
            String inName = resource.getName();
            this.monitor.subTask(AtlBuilderMessages.getString("AtlBuildVisitor.COMPILETASK", new Object[]{inName}));
            String outName = String.valueOf(inName.substring(0, inName.lastIndexOf(46))) + ".asm";
            IFile out = resource.getParent().getFile((IPath)new Path(outName));
            InputStream is = ((IFile)resource).getContents();
            try {
                EObject[] pbms = AtlCompiler.getDefault().compile(is, out);
                this.markerMaker.resetPbmMarkers(resource, pbms);
                IFile asmFile = this.getAsmFile(resource);
                if (asmFile.exists()) {
                    asmFile.setDerived(true);
                }
            }
            catch (CompilerNotFoundException cnfee) {
                IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)cnfee.getMessage());
                marker.setAttribute("lineNumber", 1);
            }
            try {
                is.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return false;
        }
        return true;
    }
}

