/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.config;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.config.BadHistogramTimerConfigBean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class BadHistogramTimerConfigTest {
    @Inject
    private MetricRegistry registry;
    @Inject
    private BadHistogramTimerConfigBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(BadHistogramTimerConfigBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml")).addAsManifestResource("META-INF/microprofile-config-badHistogramTimerConfig.properties", "microprofile-config.properties");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    public void checkBadHistogramPercentiles() {
        Histogram histogram = this.registry.getHistogram(new MetricID("badHistogramPercentiles"));
        Snapshot.PercentileValue[] percentiles = histogram.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)3));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)0.1), Matchers.equalTo((Object)0.3), Matchers.equalTo((Object)0.4)}));
    }

    @Test
    public void checkBadTimerPercentiles() {
        Timer timer = this.registry.getTimer(new MetricID("badTimerPercentiles"));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)1));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)0.1)));
    }

    @Test
    public void checkBadHistogramBuckets() {
        Histogram histogram = this.registry.getHistogram(new MetricID("badHistogramBuckets"));
        Snapshot.HistogramBucket[] buckets = histogram.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)3));
        List bucketsList = Stream.of(buckets).map(bucket -> bucket.getBucket()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)10.0), Matchers.equalTo((Object)12.0), Matchers.equalTo((Object)90.0)}));
    }

    @Test
    public void checkBadTimerBuckets() {
        Timer histogram = this.registry.getTimer(new MetricID("badTimerBuckets"));
        Snapshot.HistogramBucket[] buckets = histogram.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)3));
        List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)10L), Matchers.equalTo((Object)30L), Matchers.equalTo((Object)500L)}));
    }
}

