/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.asynchronous;

import jakarta.enterprise.context.RequestScoped;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class AsyncCancellationClient {
    private AtomicInteger serviceAsyncRetryAttempts = new AtomicInteger(0);

    @Asynchronous
    public Future<?> serviceAsync(Barrier barrier, AtomicBoolean wasInterrupted) {
        try {
            barrier.awaitInterruptably();
        }
        catch (InterruptedException e) {
            wasInterrupted.set(true);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Asynchronous
    @Retry(maxRetries=5, delay=0L, jitter=0L)
    public Future<?> serviceAsyncRetry(Barrier barrier) throws InterruptedException {
        this.serviceAsyncRetryAttempts.incrementAndGet();
        barrier.awaitInterruptably();
        return CompletableFuture.completedFuture(null);
    }

    public int getServiceAsyncRetryAttempts() {
        return this.serviceAsyncRetryAttempts.get();
    }

    @Asynchronous
    @Bulkhead(value=1, waitingTaskQueue=1)
    public Future<?> serviceAsyncBulkhead(Barrier barrier) {
        barrier.await();
        return CompletableFuture.completedFuture(null);
    }
}

