/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.misc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DisjointSet<T> {
    private final HashMap<T, Node<T>> objectsToNodes = new HashMap();

    public T findSet(Object o) {
        Node<T> node = this.objectsToNodes.get(o);
        if (node == null) {
            return null;
        }
        if (o != node.parent) {
            node.parent = this.findSet(node.parent);
        }
        return node.parent;
    }

    public void makeSet(T o) {
        this.objectsToNodes.put(o, new Node<T>(o, 0));
    }

    public void removeSet(Object o) {
        T set = this.findSet(o);
        if (set == null) {
            return;
        }
        Iterator<T> it = this.objectsToNodes.keySet().iterator();
        while (it.hasNext()) {
            T next = it.next();
            if (next == set || this.findSet(next) != set) continue;
            it.remove();
        }
        this.objectsToNodes.remove(set);
    }

    public void toList(List<? super T> list) {
        list.addAll(this.objectsToNodes.keySet());
    }

    public void union(T x, T y) {
        T setX = this.findSet(x);
        T setY = this.findSet(y);
        if (setX == null || setY == null || setX == setY) {
            return;
        }
        Node<T> nodeX = this.objectsToNodes.get(setX);
        Node<T> nodeY = this.objectsToNodes.get(setY);
        if (nodeX.rank > nodeY.rank) {
            nodeY.parent = x;
        } else {
            nodeX.parent = y;
            if (nodeX.rank == nodeY.rank) {
                ++nodeY.rank;
            }
        }
    }

    private static class Node<T> {
        int rank;
        T parent;

        Node(T parent, int rank) {
            this.parent = parent;
            this.rank = rank;
        }
    }
}

