/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder.rewriters;

import java.util.Map;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;

public class PathRewriter
extends AbstractRewriter<Path>
implements PathVisitor {
    public PathRewriter(Map<Var, Node> values) {
        super(values);
    }

    public void visit(P_Link pathNode) {
        this.push(new P_Link(this.changeNode(pathNode.getNode())));
    }

    public void visit(P_ReverseLink pathNode) {
        this.push(new P_ReverseLink(this.changeNode(pathNode.getNode())));
    }

    public void visit(P_NegPropSet pathNotOneOf) {
        P_NegPropSet retval = new P_NegPropSet();
        for (Path p : pathNotOneOf.getNodes()) {
            p.visit((PathVisitor)this);
            retval.add((P_Path0)this.pop());
        }
        this.push(retval);
    }

    public void visit(P_Inverse inversePath) {
        inversePath.getSubPath().visit((PathVisitor)this);
        this.push(new P_Inverse((Path)this.pop()));
    }

    public void visit(P_Mod pathMod) {
        pathMod.getSubPath().visit((PathVisitor)this);
        this.push(new P_Mod((Path)this.pop(), pathMod.getMin(), pathMod.getMax()));
    }

    public void visit(P_FixedLength pFixedLength) {
        pFixedLength.getSubPath().visit((PathVisitor)this);
        this.push(new P_FixedLength((Path)this.pop(), pFixedLength.getCount()));
    }

    public void visit(P_Alt pathAlt) {
        pathAlt.getRight().visit((PathVisitor)this);
        pathAlt.getLeft().visit((PathVisitor)this);
        this.push(new P_Alt((Path)this.pop(), (Path)this.pop()));
    }

    public void visit(P_Seq pathSeq) {
        pathSeq.getRight().visit((PathVisitor)this);
        pathSeq.getLeft().visit((PathVisitor)this);
        this.push(new P_Seq((Path)this.pop(), (Path)this.pop()));
    }

    public void visit(P_Distinct pathDistinct) {
        pathDistinct.getSubPath().visit((PathVisitor)this);
        this.push(new P_Distinct((Path)this.pop()));
    }

    public void visit(P_Multi pathMulti) {
        pathMulti.getSubPath().visit((PathVisitor)this);
        this.push(new P_Multi((Path)this.pop()));
    }

    public void visit(P_Shortest pathShortest) {
        pathShortest.getSubPath().visit((PathVisitor)this);
        this.push(new P_Shortest((Path)this.pop()));
    }

    public void visit(P_ZeroOrOne path) {
        path.getSubPath().visit((PathVisitor)this);
        this.push(new P_ZeroOrOne((Path)this.pop()));
    }

    public void visit(P_ZeroOrMore1 path) {
        path.getSubPath().visit((PathVisitor)this);
        this.push(new P_ZeroOrMore1((Path)this.pop()));
    }

    public void visit(P_ZeroOrMoreN path) {
        path.getSubPath().visit((PathVisitor)this);
        this.push(new P_ZeroOrMoreN((Path)this.pop()));
    }

    public void visit(P_OneOrMore1 path) {
        path.getSubPath().visit((PathVisitor)this);
        this.push(new P_OneOrMore1((Path)this.pop()));
    }

    public void visit(P_OneOrMoreN path) {
        path.getSubPath().visit((PathVisitor)this);
        this.push(new P_OneOrMoreN((Path)this.pop()));
    }
}

