/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.lib.tuple.Tuple3;
import org.apache.jena.atlas.lib.tuple.TupleFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.main.solver.SolverRX4;
import org.apache.jena.tdb.lib.TupleLib;
import org.apache.jena.tdb.solver.BindingNodeId;
import org.apache.jena.tdb.solver.BindingTDB;
import org.apache.jena.tdb.solver.SolverLibTDB;
import org.apache.jena.tdb.solver.StageMatchTuple;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;

public class SolverRX {
    public static final boolean DATAPATH = true;
    private static Function<Tuple<NodeId>, Tuple<NodeId>> quadsToAnyTriples = item -> TupleFactory.create4((Object)NodeId.NodeIdAny, (Object)((NodeId)item.get(1)), (Object)((NodeId)item.get(2)), (Object)((NodeId)item.get(3)));

    static Iterator<BindingNodeId> matchQuadPattern(Iterator<BindingNodeId> chain, Node graphNode, Triple tPattern, NodeTupleTable nodeTupleTable, Tuple<Node> patternTuple, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        if (!SolverLib.tripleHasEmbTripleWithVars((Triple)tPattern)) {
            return StageMatchTuple.access(nodeTupleTable, chain, patternTuple, filter, anyGraph, execCxt);
        }
        boolean isTriple = patternTuple.len() == 3;
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Function<BindingNodeId, Iterator> step = bnid -> SolverRX.find(bnid, nodeTupleTable, graphNode, tPattern, anyGraph, filter, execCxt);
        return Iter.flatMap(chain, step);
    }

    private static Iterator<BindingNodeId> find(BindingNodeId bnid, NodeTupleTable nodeTupleTable, Node xGraphNode, Triple xPattern, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Object input = bnid.isEmpty() ? BindingFactory.empty() : new BindingTDB(bnid, nodeTable);
        Triple tPattern = Substitute.substitute((Triple)xPattern, (Binding)input);
        Node graphNode = Substitute.substitute((Node)xGraphNode, (Binding)input);
        Node tGraphNode = anyGraph ? Quad.unionGraph : graphNode;
        Node g = graphNode == null ? null : SolverLib.nodeTopLevel((Node)graphNode);
        Node s = SolverLib.nodeTopLevel((Node)tPattern.getSubject());
        Node p = SolverLib.nodeTopLevel((Node)tPattern.getPredicate());
        Node o = SolverLib.nodeTopLevel((Node)tPattern.getObject());
        Tuple3 patternTuple = g == null ? TupleFactory.create3((Object)s, (Object)p, (Object)o) : TupleFactory.create4((Object)g, (Object)s, (Object)p, (Object)o);
        Iterator<Quad> dsgIter = SolverRX.accessData((Tuple<Node>)patternTuple, nodeTupleTable, anyGraph, filter, execCxt);
        Iter matched = Iter.iter(dsgIter).map(arg_0 -> SolverRX.lambda$find$1((Binding)input, tGraphNode, tPattern, arg_0)).removeNulls();
        return SolverLibTDB.convFromBinding((Iterator<Binding>)matched, nodeTable);
    }

    private static Iterator<Quad> accessData(Tuple<Node> patternTuple, NodeTupleTable nodeTupleTable, boolean anyGraph, Predicate<Tuple<NodeId>> filter, ExecutionContext execCxt) {
        NodeTable nodeTable = nodeTupleTable.getNodeTable();
        Tuple<NodeId> patternTupleId = TupleLib.tupleNodeIds(nodeTable, patternTuple);
        if (patternTupleId.contains((Object)NodeId.NodeDoesNotExist)) {
            return Iter.nullIterator();
        }
        Iterator iterMatches = nodeTupleTable.find(patternTupleId);
        if (filter != null) {
            iterMatches = Iter.filter(iterMatches, filter);
        }
        if (anyGraph) {
            iterMatches = Iter.map((Iterator)iterMatches, quadsToAnyTriples);
            iterMatches = Iter.distinctAdjacent((Iterator)iterMatches);
        }
        Function<Tuple<NodeId>, Quad> asQuad = SolverRX.asQuad(nodeTable, nodeTupleTable.getTupleLen(), anyGraph);
        Iterator qIter = Iter.map((Iterator)iterMatches, asQuad);
        return qIter;
    }

    private static Function<Tuple<NodeId>, Quad> asQuad(NodeTable nodeTable, int tupleLen, boolean anyGraph) {
        switch (tupleLen) {
            case 3: {
                return t -> {
                    Node gx = Quad.defaultGraphIRI;
                    Node sx = SolverRX.toNode((NodeId)t.get(0), nodeTable);
                    Node px = SolverRX.toNode((NodeId)t.get(1), nodeTable);
                    Node ox = SolverRX.toNode((NodeId)t.get(2), nodeTable);
                    return Quad.create((Node)gx, (Node)sx, (Node)px, (Node)ox);
                };
            }
            case 4: {
                return t -> {
                    Node gx = anyGraph ? Quad.unionGraph : SolverRX.toNode((NodeId)t.get(0), nodeTable);
                    Node sx = SolverRX.toNode((NodeId)t.get(1), nodeTable);
                    Node px = SolverRX.toNode((NodeId)t.get(2), nodeTable);
                    Node ox = SolverRX.toNode((NodeId)t.get(3), nodeTable);
                    return Quad.create((Node)gx, (Node)sx, (Node)px, (Node)ox);
                };
            }
        }
        throw new InternalErrorException("Tuple of unknown length");
    }

    private static Node toNode(NodeId nodeId, NodeTable nodeTable) {
        return nodeTable.getNodeForNodeId(nodeId);
    }

    private static /* synthetic */ Binding lambda$find$1(Binding input, Node tGraphNode, Triple tPattern, Quad dQuad) {
        return SolverRX4.matchQuad((Binding)input, (Quad)dQuad, (Node)tGraphNode, (Triple)tPattern);
    }
}

