/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.collection;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.function.Predicate;
import org.apache.jena.mem2.iterator.SparseArrayIterator;
import org.apache.jena.mem2.spliterator.SparseArraySpliterator;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;

public abstract class HashCommonBase<E> {
    protected static final double LOAD_FACTOR = 0.5;
    static final int[] primes = new int[]{7, 19, 37, 79, 149, 307, 617, 1237, 2477, 4957, 9923, 19853, 39709, 79423, 158849, 317701, 635413, 1270849, 2541701, 5083423, 10166857, 20333759, 40667527, 81335047, 162670111, 325340233, 650680469, 982451653};
    protected E[] keys;
    protected int threshold;
    protected int size = 0;

    protected HashCommonBase(int initialCapacity) {
        this.keys = this.newKeysArray(initialCapacity);
        this.threshold = (int)((double)this.keys.length * 0.5);
    }

    protected static int nextSize(int atLeast) {
        for (int prime : primes) {
            if (prime <= atLeast) continue;
            return prime;
        }
        throw new JenaException("Failed to find a 'next size': atLeast = " + atLeast);
    }

    protected void clear(int initialCapacity) {
        this.size = 0;
        this.keys = this.newKeysArray(initialCapacity);
        this.threshold = (int)((double)this.keys.length * 0.5);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected abstract E[] newKeysArray(int var1);

    protected final int initialIndexFor(int hashOfKey) {
        return (this.improveHashCode(hashOfKey) & Integer.MAX_VALUE) % this.keys.length;
    }

    protected int improveHashCode(int hashCode) {
        return hashCode * 127;
    }

    protected abstract void grow();

    protected int calcGrownCapacityAndSetThreshold() {
        int capacity = HashCommonBase.nextSize(this.keys.length * 2);
        this.threshold = (int)((double)capacity * 0.5);
        return capacity;
    }

    protected abstract void removeFrom(int var1);

    public boolean tryRemove(E key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.removeFrom(~slot);
            return true;
        }
        return false;
    }

    public void removeUnchecked(E key) {
        int slot = this.findSlot(key);
        if (slot < 0) {
            this.removeFrom(~slot);
        }
    }

    protected int findSlot(E key) {
        int index = this.initialIndexFor(key.hashCode());
        E current;
        while ((current = this.keys[index]) != null) {
            if (key.equals(current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.keys.length;
        }
        return index;
    }

    public boolean containsKey(E key) {
        return this.findSlot(key) < 0;
    }

    public boolean anyMatch(Predicate<E> predicate) {
        for (int pos = this.keys.length - 1; -1 < pos; --pos) {
            if (null == this.keys[pos] || !predicate.test(this.keys[pos])) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator<E> keyIterator() {
        int initialSize = this.size;
        Runnable checkForConcurrentModification = () -> {
            if (this.size != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArrayIterator<E>(this.keys, checkForConcurrentModification);
    }

    public Spliterator<E> keySpliterator() {
        int initialSize = this.size;
        Runnable checkForConcurrentModification = () -> {
            if (this.size != initialSize) {
                throw new ConcurrentModificationException();
            }
        };
        return new SparseArraySpliterator<E>(this.keys, checkForConcurrentModification);
    }
}

