/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIProviderJDK;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;

public class SystemIRIx {
    private static IRIProvider providerJenaIRI = SystemIRIx.makeProviderJenaIRI();
    private static IRIProvider provider = SystemIRIx.makeFreshSystemProvider();
    private static final IRIx cwdURI;
    private static IRIx systemBase;
    private static String fallbackBaseURI;

    private static IRIProvider makeProviderJenaIRI() {
        IRIProviderJenaIRI newProviderJenaIRI = new IRIProviderJenaIRI();
        newProviderJenaIRI.strictMode("urn", false);
        newProviderJenaIRI.strictMode("http", false);
        newProviderJenaIRI.strictMode("file", false);
        return newProviderJenaIRI;
    }

    private static IRIProvider makeProviderJDK() {
        return new IRIProviderJDK();
    }

    public static IRIProvider makeFreshSystemProvider() {
        return SystemIRIx.makeProviderJenaIRI();
    }

    public static void init() {
    }

    public static void reset() {
        provider = SystemIRIx.makeFreshSystemProvider();
    }

    public static void setProvider(IRIProvider aProvider) {
        provider = aProvider;
        IRIx iri = SystemIRIx.setupBase(systemBase.str());
        SystemIRIx.setSystemBase(iri);
    }

    public static IRIProvider getProvider() {
        return provider;
    }

    public static void strictMode(String scheme, boolean runStrict) {
        SystemIRIx.getProvider().strictMode(scheme, runStrict);
    }

    public static boolean isStrictMode(String scheme) {
        return SystemIRIx.getProvider().isStrictMode(scheme);
    }

    static IRIx getSystemBase() {
        return systemBase;
    }

    private static IRIx establishBaseURI() {
        try {
            Object baseStr = IRILib.filenameToIRI((String)"./");
            if (!((String)baseStr).endsWith("/")) {
                baseStr = (String)baseStr + "/";
            }
            return SystemIRIx.setupBase((String)baseStr);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return IRIx.create(fallbackBaseURI);
        }
    }

    private static IRIx setupBase(String baseStr) {
        if (baseStr == null) {
            return IRIx.create(fallbackBaseURI);
        }
        try {
            IRIx base;
            if (!((String)baseStr).endsWith("/")) {
                baseStr = (String)baseStr + "/";
            }
            if (!(base = IRIx.create((String)baseStr)).isReference()) {
                Log.error(IRIs.class, (String)"System base URI is not a reference URI: must have scheme, host and path");
            }
            return base;
        }
        catch (IRIException ex) {
            Log.error(IRIs.class, (String)("Failed to create IRI from '" + (String)baseStr + "'"), (Throwable)ex);
            return IRIx.create(fallbackBaseURI);
        }
    }

    private static void setSystemBase(IRIx iri) {
        systemBase = iri;
    }

    static {
        systemBase = cwdURI = SystemIRIx.establishBaseURI();
        fallbackBaseURI = "urn:jena:base";
    }
}

