/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system.buffering;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.system.buffering.BufferingCtl;

public class BufferingPrefixMapping
extends PrefixMappingImpl
implements BufferingCtl {
    private static final boolean CHECK = false;
    private final PrefixMapping added = new PrefixMappingImpl();
    private final Set<String> deleted = new HashSet<String>();
    private final PrefixMapping other;

    public BufferingPrefixMapping(PrefixMapping other) {
        this.other = other;
    }

    public PrefixMapping base() {
        return this.other;
    }

    @Override
    public void flush() {
        this.deleted.forEach(prefix -> this.other.removeNsPrefix(prefix));
        this.other.setNsPrefixes(this.added);
        this.deleted.clear();
        this.added.clearNsPrefixMap();
    }

    public PrefixMapping getAdded() {
        return this.added;
    }

    public Set<String> getDeleted() {
        return this.deleted;
    }

    protected void set(String prefix, String uri) {
        this.added.setNsPrefix(prefix, uri);
    }

    protected String get(String prefix) {
        if (this.deleted.contains(prefix)) {
            return null;
        }
        String uri = this.added.getNsPrefixURI(prefix);
        if (uri != null) {
            return uri;
        }
        return this.other.getNsPrefixURI(prefix);
    }

    protected void remove(String prefix) {
        this.deleted.add(prefix);
        this.added.removeNsPrefix(prefix);
    }

    public int numPrefixes() {
        return this.added.numPrefixes() - this.deleted.size() + this.other.numPrefixes();
    }

    public boolean hasNoMappings() {
        return this.numPrefixes() == 0;
    }
}

