/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4e.debug.DSPPlugin;
import org.eclipse.lsp4e.debug.console.DSPProcess;
import org.eclipse.lsp4e.debug.console.DSPStreamsProxy;
import org.eclipse.lsp4e.debug.debugmodel.DSPBreakpointManager;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.lsp4e.debug.debugmodel.TransportStreams;
import org.eclipse.lsp4e.internal.ArrayUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.debug.BreakpointEventArguments;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinuedEventArguments;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.ExitedEventArguments;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.LoadedSourceEventArguments;
import org.eclipse.lsp4j.debug.ModuleEventArguments;
import org.eclipse.lsp4j.debug.OutputEventArguments;
import org.eclipse.lsp4j.debug.ProcessEventArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArguments;
import org.eclipse.lsp4j.debug.RunInTerminalRequestArgumentsKind;
import org.eclipse.lsp4j.debug.RunInTerminalResponse;
import org.eclipse.lsp4j.debug.StartDebuggingRequestArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.TerminateArguments;
import org.eclipse.lsp4j.debug.TerminatedEventArguments;
import org.eclipse.lsp4j.debug.ThreadEventArguments;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.validation.ReflectiveMessageValidator;

public class DSPDebugTarget
extends DSPDebugElement
implements IDebugTarget,
IDebugProtocolClient {
    private static final boolean TRACE_IO = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.lsp4e.debug/trace/io"));
    private static final boolean TRACE_MESSAGES = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.lsp4e.debug/trace/messages"));
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final ILaunch launch;
    private Future<?> debugProtocolFuture = (Future)NullSafetyHelper.lateNonNull();
    private IDebugProtocolServer debugProtocolServer = (IDebugProtocolServer)NullSafetyHelper.lateNonNull();
    private final CompletableFuture<@Nullable Capabilities> capabilitiesFuture = new CompletableFuture();
    private final CompletableFuture<@Nullable Void> initialized = new CompletableFuture();
    private final Set<DSPDebugTarget> debuggees = new HashSet<DSPDebugTarget>();
    private final Map<Integer, DSPThread> threads = Collections.synchronizedMap(new TreeMap());
    private boolean fTerminated = false;
    private boolean fSentTerminateRequest = false;
    private String targetName = (String)NullSafetyHelper.lateNonNull();
    private @Nullable DSPBreakpointManager breakpointManager;
    private @Nullable DSPProcess process;
    private TransportStreams transportStreams;
    private final Supplier<TransportStreams> streamsSupplier;
    private final Map<String, Object> dspParameters;

    public DSPDebugTarget(ILaunch launch, final Runnable cleanup, InputStream in, OutputStream out, Map<String, Object> dspParameters) {
        this(launch, () -> new TransportStreams.DefaultTransportStreams(in, out){

            @Override
            public void close() {
                super.close();
                cleanup.run();
            }
        }, dspParameters);
    }

    public DSPDebugTarget(ILaunch launch, Supplier<TransportStreams> streamsSupplier, Map<String, Object> dspParameters) {
        super(null);
        this.transportStreams = streamsSupplier.get();
        this.streamsSupplier = streamsSupplier;
        this.launch = launch;
        this.dspParameters = dspParameters;
    }

    public void initialize(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                PrintWriter traceMessages = TRACE_MESSAGES ? new PrintWriter(System.out) : null;
                if (TRACE_IO) {
                    this.transportStreams = this.transportStreams.withTrace();
                }
                UnaryOperator wrapper = consumer -> {
                    MessageConsumer result = consumer;
                    if (traceMessages != null) {
                        result = message -> {
                            traceMessages.println(message);
                            traceMessages.flush();
                            consumer.consume(message);
                        };
                    }
                    result = new ReflectiveMessageValidator(result);
                    return result;
                };
                InputStream in2 = this.transportStreams.in;
                OutputStream out2 = this.transportStreams.out;
                ExecutorService threadPool2 = this.threadPool;
                Launcher<? extends IDebugProtocolServer> debugProtocolLauncher = this.createLauncher(wrapper, in2, out2, threadPool2);
                this.debugProtocolFuture = debugProtocolLauncher.startListening();
                this.debugProtocolServer = (IDebugProtocolServer)debugProtocolLauncher.getRemoteProxy();
                CompletableFuture<?> future = this.initialize(this.dspParameters, (IProgressMonitor)subMonitor);
                future.thenRun(this::triggerUpdateThreads);
                DSPDebugTarget.monitorGet(future, (IProgressMonitor)subMonitor);
            }
            catch (Exception e) {
                this.terminated();
                throw e;
            }
        }
        finally {
            subMonitor.done();
        }
    }

    protected Launcher<? extends IDebugProtocolServer> createLauncher(UnaryOperator<MessageConsumer> wrapper, InputStream in, OutputStream out, ExecutorService threadPool) {
        Launcher debugProtocolLauncher = DSPLauncher.createClientLauncher((IDebugProtocolClient)this, (InputStream)in, (OutputStream)out, (ExecutorService)threadPool, wrapper);
        return debugProtocolLauncher;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private CompletableFuture<?> initialize(Map<String, Object> dspParameters, IProgressMonitor monitor) {
        InitializeRequestArguments arguments = new InitializeRequestArguments();
        arguments.setClientID("lsp4e.debug");
        String adapterId = "adapterId";
        Object object = dspParameters.get("type");
        if (object instanceof String) {
            String type;
            adapterId = type = (String)object;
        }
        arguments.setAdapterID(adapterId);
        arguments.setPathFormat("path");
        arguments.setSupportsVariableType(Boolean.valueOf(true));
        arguments.setSupportsVariablePaging(Boolean.valueOf(true));
        arguments.setLinesStartAt1(Boolean.valueOf(true));
        arguments.setColumnsStartAt1(Boolean.valueOf(true));
        arguments.setSupportsRunInTerminalRequest(Boolean.valueOf(true));
        arguments.setSupportsStartDebuggingRequest(Boolean.TRUE);
        this.targetName = Objects.toString(dspParameters.get("program"), "Debug Adapter Target");
        monitor.subTask("Initializing connection to debug adapter");
        boolean isLaunchRequest = "launch".equals(dspParameters.getOrDefault("request", "launch"));
        CompletionStage launchAttachFuture = ((CompletableFuture)((CompletableFuture)this.getDebugProtocolServer().initialize(arguments).thenAccept(capabilities -> {
            monitor.worked(10);
            if (capabilities == null) {
                DSPPlugin.logError("Debug adapter unexpectedly returned 'null' Capabilities from initializeRequest. A default Capabilities will be used instead.", null);
                capabilities = new Capabilities();
            }
            this.capabilitiesFuture.complete((Capabilities)capabilities);
        })).thenCompose(v -> {
            monitor.worked(10);
            if (isLaunchRequest) {
                monitor.subTask("Launching program");
                return this.getDebugProtocolServer().launch(dspParameters);
            }
            monitor.subTask("Attaching to running program");
            return this.getDebugProtocolServer().attach(dspParameters);
        })).handle((q, t) -> {
            if (t != null) {
                this.initialized.completeExceptionally((Throwable)t);
            }
            return q;
        });
        @Nullable CompletionStage configurationDoneFuture = CompletableFuture.allOf(this.initialized, this.capabilitiesFuture).thenRun(() -> monitor.worked(10));
        if ("debug".equals(this.launch.getLaunchMode())) {
            configurationDoneFuture = ((CompletableFuture)configurationDoneFuture).thenCompose(v -> {
                monitor.worked(10);
                monitor.subTask("Sending breakpoints");
                this.breakpointManager = new DSPBreakpointManager(this.getBreakpointManager(), this.getDebugProtocolServer(), this.getCapabilities());
                return this.breakpointManager.initialize();
            });
        }
        configurationDoneFuture = ((CompletableFuture)configurationDoneFuture).thenCompose(v -> {
            monitor.worked(30);
            monitor.subTask("Sending configuration done");
            if (Boolean.TRUE.equals(((Capabilities)NullSafetyHelper.castNonNull((Object)this.getCapabilities())).getSupportsConfigurationDoneRequest())) {
                return this.getDebugProtocolServer().configurationDone(new ConfigurationDoneArguments());
            }
            return CompletableFuture.completedFuture(null);
        });
        return CompletableFuture.allOf(new CompletableFuture[]{launchAttachFuture, configurationDoneFuture});
    }

    private void terminated() {
        this.fTerminated = true;
        DSPThread[] dSPThreadArray = this.getThreads();
        int n = dSPThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            DSPThread t = dSPThreadArray[n2];
            try {
                t.terminate();
            }
            catch (DebugException e) {
                DSPPlugin.logError(e);
            }
            ++n2;
        }
        DSPProcess process = this.process;
        if (process != null && process.canTerminate()) {
            try {
                process.terminate();
            }
            catch (DebugException e) {
                DSPPlugin.logError(e);
            }
        }
        this.fireTerminateEvent();
        this.debuggees.forEach(DSPDebugTarget::terminated);
        if (this.breakpointManager != null) {
            this.breakpointManager.shutdown();
        }
        if (this.debugProtocolFuture != null) {
            this.debugProtocolFuture.cancel(true);
            Thread.interrupted();
        }
        this.transportStreams.close();
    }

    public void initialized() {
        this.initialized.complete(null);
    }

    public CompletableFuture<Void> startDebugging(StartDebuggingRequestArguments args) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.putAll(args.getConfiguration());
        try {
            DSPDebugTarget newTarget = new DSPDebugTarget(this.launch, this.streamsSupplier, parameters);
            this.launch.addDebugTarget((IDebugTarget)newTarget);
            newTarget.initialize((IProgressMonitor)new NullProgressMonitor());
            this.debuggees.add(newTarget);
        }
        catch (CoreException e) {
            DSPPlugin.logError(e);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected void requestFailed(String message, @Nullable Throwable e) throws DebugException {
        throw DSPDebugTarget.newTargetRequestFailedException(message, e);
    }

    @Override
    public DSPDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public <T> @Nullable T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminated(TerminatedEventArguments body) {
        this.terminated();
    }

    public void terminate() throws DebugException {
        boolean shouldSendTerminateRequest;
        boolean bl = shouldSendTerminateRequest = !this.fSentTerminateRequest && Boolean.TRUE.equals(((Capabilities)NullSafetyHelper.castNonNull((Object)this.getCapabilities())).getSupportsTerminateRequest()) && "launch".equals(this.dspParameters.getOrDefault("request", "launch"));
        if (shouldSendTerminateRequest) {
            this.fSentTerminateRequest = true;
            this.getDebugProtocolServer().terminate(new TerminateArguments()).thenRunAsync(this::terminated);
        } else {
            DisconnectArguments arguments = new DisconnectArguments();
            arguments.setTerminateDebuggee(Boolean.valueOf(true));
            this.getDebugProtocolServer().disconnect(arguments).thenRunAsync(this::terminated);
        }
    }

    public void continued(ContinuedEventArguments body) {
        this.threadPool.execute(() -> {
            DSPThread source = null;
            source = this.getThread(body.getThreadId());
            if (source == null || body.getAllThreadsContinued() == null || body.getAllThreadsContinued().booleanValue()) {
                ArrayUtil.forEach((Object[])this.getThreads(), DSPThread::continued);
            }
            if (source != null) {
                source.fireResumeEvent(32);
            }
        });
    }

    public void stopped(StoppedEventArguments body) {
        this.triggerUpdateThreads().thenRunAsync(() -> {
            DSPThread source = null;
            if (body.getThreadId() != null) {
                source = this.getThread(body.getThreadId());
            }
            if (source == null || body.getAllThreadsStopped() == null || body.getAllThreadsStopped().booleanValue()) {
                DSPThread[] dSPThreadArray = this.getThreads();
                int n = dSPThreadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DSPThread t = dSPThreadArray[n2];
                    t.stopped();
                    t.fireChangeEvent(16);
                    ++n2;
                }
            }
            if (source != null) {
                source.stopped();
                source.fireSuspendEvent(this.calcDetail(body.getReason()));
            }
        }, this.threadPool);
    }

    private int calcDetail(String reason) {
        if (reason.equals("breakpoint") || reason.equals("entry") || reason.equals("exception")) {
            return 16;
        }
        if (reason.equals("step")) {
            return 2;
        }
        if (reason.equals("pause")) {
            return 32;
        }
        return 0;
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended() && this.getThreads().length > 0;
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended() && this.getThreads().length > 0;
    }

    public boolean isSuspended() {
        DSPThread[] dspThreads = this.getThreads();
        return ArrayUtil.anyMatch((Object[])dspThreads, DSPThread::isSuspended);
    }

    public void resume() throws DebugException {
        DSPThread[] dspThreads = this.getThreads();
        if (dspThreads.length > 0) {
            dspThreads[0].resume();
        }
    }

    public void suspend() throws DebugException {
        DSPThread[] dspThreads = this.getThreads();
        if (dspThreads.length > 0) {
            dspThreads[0].suspend();
        }
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public void disconnect() throws DebugException {
        this.getDebugProtocolServer().disconnect(new DisconnectArguments()).thenRun(this::terminated);
    }

    public boolean isDisconnected() {
        return this.fTerminated;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(0, "org.eclipse.lsp4e.debug", 5010, "not implemented", null));
    }

    public @Nullable IProcess getProcess() {
        return this.process;
    }

    public DSPThread[] getThreads() {
        return (DSPThread[])this.threads.values().toArray(DSPThread[]::new);
    }

    private DSPThread getThread(Integer threadId) {
        return this.threads.computeIfAbsent(threadId, id -> new DSPThread(this, threadId));
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreads().length > 0;
    }

    public String getName() {
        return this.targetName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return !this.isTerminated() && this.breakpointManager != null && this.breakpointManager.supportsBreakpoint(breakpoint);
    }

    public void exited(ExitedEventArguments args) {
    }

    public void thread(ThreadEventArguments args) {
        this.triggerUpdateThreads();
    }

    private CompletableFuture<?> triggerUpdateThreads() {
        return this.getDebugProtocolServer().threads().thenAcceptAsync(threadsResponse -> {
            Set threadIds = Arrays.stream(threadsResponse.getThreads()).map(org.eclipse.lsp4j.debug.Thread::getId).collect(Collectors.toSet());
            boolean contentChanged = false;
            Map<Integer, DSPThread> map = this.threads;
            synchronized (map) {
                contentChanged = this.threads.keySet().removeIf(Predicate.not(threadIds::contains));
                org.eclipse.lsp4j.debug.Thread[] threadArray = threadsResponse.getThreads();
                int n = threadArray.length;
                int n2 = 0;
                while (n2 < n) {
                    org.eclipse.lsp4j.debug.Thread thread = threadArray[n2];
                    DSPThread dspThread = this.threads.get(thread.getId());
                    if (dspThread == null) {
                        dspThread = new DSPThread(this, thread.getId());
                        this.threads.put(dspThread.getId(), dspThread);
                        contentChanged = true;
                    }
                    dspThread.update(thread);
                    ++n2;
                }
            }
            if (contentChanged) {
                this.fireChangeEvent(512);
            }
        });
    }

    public void output(OutputEventArguments args) {
        String output = args.getOutput();
        if (args.getCategory() == null || "console".equals(args.getCategory()) || "stdout".equals(args.getCategory())) {
            this.getOrCreateStreamsProxy().getOutputStreamMonitor().append(output);
        } else if ("stderr".equals(args.getCategory())) {
            this.getOrCreateStreamsProxy().getErrorStreamMonitor().append(output);
        } else if (DSPPlugin.DEBUG) {
            System.out.println("output: " + String.valueOf(args));
        }
    }

    private DSPStreamsProxy getOrCreateStreamsProxy() {
        DSPProcess process = this.process;
        if (process == null) {
            this.process(null);
            process = (DSPProcess)NullSafetyHelper.castNonNull((Object)this.process);
        }
        return process.getStreamsProxy();
    }

    public void module(ModuleEventArguments args) {
    }

    public void loadedSource(LoadedSourceEventArguments args) {
    }

    public void process(@Nullable ProcessEventArguments args) {
        this.process = new DSPProcess(this, args);
        this.launch.addProcess((IProcess)this.process);
    }

    public CompletableFuture<RunInTerminalResponse> runInTerminal(RunInTerminalRequestArguments args) {
        RunInTerminalRequestArgumentsKind.EXTERNAL.equals((Object)args.getKind());
        StringBuilder cmd = new StringBuilder();
        String[] stringArray = args.getArgs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.contains(" ")) {
                cmd.append('\"');
                cmd.append(arg);
                cmd.append('\"');
            } else {
                cmd.append(arg);
            }
            cmd.append(' ');
            ++n2;
        }
        if (cmd.length() > 0) {
            cmd.setLength(cmd.length() - 1);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(args.getArgs());
        if (args.getCwd() != null) {
            processBuilder.directory(new File(args.getCwd()));
        }
        if (args.getEnv() != null) {
            Set<Map.Entry<K, @Nullable V>> entrySet = args.getEnv().entrySet();
            for (Map.Entry entry : entrySet) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) {
                    processBuilder.environment().remove(name);
                    continue;
                }
                processBuilder.environment().put(name, value);
            }
        }
        try {
            if (DSPPlugin.DEBUG) {
                System.out.println("Launching: " + String.valueOf(cmd));
            }
            Process start = processBuilder.start();
            DebugPlugin.newProcess((ILaunch)this.launch, (Process)start, (String)cmd.toString());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            RunInTerminalResponse runInTerminalResponse = new RunInTerminalResponse();
            runInTerminalResponse.setProcessId(null);
            return CompletableFuture.completedFuture(runInTerminalResponse);
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(null);
        }
    }

    public void breakpoint(BreakpointEventArguments args) {
        if (this.breakpointManager != null) {
            this.breakpointManager.breakpointEvent(args);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.breakpointManager != null) {
            this.breakpointManager.breakpointAdded(breakpoint);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, @Nullable IMarkerDelta delta) {
        if (this.breakpointManager != null) {
            this.breakpointManager.breakpointRemoved(breakpoint, delta);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, @Nullable IMarkerDelta delta) {
        if (this.breakpointManager != null) {
            this.breakpointManager.breakpointChanged(breakpoint, delta);
        }
    }

    @Override
    public IDebugProtocolServer getDebugProtocolServer() {
        return this.debugProtocolServer;
    }

    public @Nullable Capabilities getCapabilities() {
        return this.capabilitiesFuture.getNow(null);
    }
}

