/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractElementId;

public class PropertyIdImpl
extends AbstractElementId
implements PropertyId {
    protected final @NonNull TypeId parentId;
    protected final @NonNull String name;
    protected final @NonNull Integer hashCode;

    private static int computeHashCode(@NonNull ElementId parentId, @NonNull String name) {
        return IdHash.createChildHash(parentId, name);
    }

    public PropertyIdImpl(@NonNull TypeId parentId, @NonNull String name) {
        this.parentId = parentId;
        this.name = name;
        this.hashCode = PropertyIdImpl.computeHashCode(parentId, name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitPropertyId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.parentId);
        s.append("::");
        s.append(this.name);
        return s.toString();
    }

    public @NonNull String getMetaTypeName() {
        return "Property";
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull TypeId getParent() {
        return this.parentId;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    public static class PropertyIdSingletonScope
    extends AbstractSingletonScope<PropertyId, String> {
        public @NonNull PropertyId getSingleton(@NonNull TypeId parentId, @NonNull String value) {
            return this.getSingletonFor(new PropertyIdValue(parentId, value));
        }
    }

    private static class PropertyIdValue
    extends SingletonScope.AbstractKeyAndValue<PropertyId> {
        private final @NonNull TypeId parentId;
        private final @NonNull String value;

        private PropertyIdValue(@NonNull TypeId parentId, @NonNull String value) {
            super(PropertyIdImpl.computeHashCode(parentId, value));
            this.parentId = parentId;
            this.value = value;
        }

        @Override
        public @NonNull PropertyId createSingleton() {
            return new PropertyIdImpl(this.parentId, this.value);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof PropertyIdImpl) {
                PropertyIdImpl singleton = (PropertyIdImpl)that;
                return this.value.equals(singleton.getName());
            }
            return false;
        }
    }
}

