/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.context.Base2ASConversion;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.scoping.NullAttribution;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public abstract class AbstractParserContext
implements ParserContext {
    private static final Logger logger = Logger.getLogger(AbstractParserContext.class);
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull URI uri;
    protected @Nullable Element rootElement = null;
    private @NonNull Map<@NonNull EClassifier, @NonNull Attribution> attributionRegistry = Attribution.REGISTRY;

    protected AbstractParserContext(@NonNull EnvironmentFactory environmentFactory, @Nullable URI uri) {
        this.environmentFactory = (EnvironmentFactoryInternal)environmentFactory;
        this.uri = uri != null ? uri : ClassUtil.nonNullEMF(URI.createURI((String)(String.valueOf(EcoreUtil.generateUUID()) + ".essentialocl")));
        this.attributionRegistry = Attribution.REGISTRY;
    }

    protected void addAttribution(EClass eClass, @NonNull Attribution attribution) {
        if (this.attributionRegistry == Attribution.REGISTRY) {
            this.attributionRegistry = new HashMap<EClassifier, Attribution>(Attribution.REGISTRY);
        }
        assert (eClass != null);
        this.attributionRegistry.put((EClassifier)eClass, attribution);
    }

    @Override
    public @NonNull CSResource createBaseResource(@Nullable String expression) throws IOException, ParserException {
        try (URIConverter.ReadableInputStream inputStream = expression != null ? new URIConverter.ReadableInputStream(expression, "UTF-8") : null;){
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            Resource resource = resourceSet.createResource(this.uri);
            if (resource == null) {
                throw new ParserException("Failed to load '" + this.uri + "'" + this.getDoSetupMessage());
            }
            if (!(resource instanceof CSResource)) {
                throw new ParserException("Failed to create Xtext resource for '" + this.uri + "'" + this.getDoSetupMessage());
            }
            CSResource baseResource = (CSResource)resource;
            this.getEnvironmentFactory().adapt((Notifier)resource);
            baseResource.setParserContext(this);
            if (inputStream != null) {
                baseResource.load((InputStream)inputStream, null);
            } else {
                baseResource.load(null);
            }
            CSResource cSResource = baseResource;
            return cSResource;
        }
    }

    @Override
    public @NonNull Attribution getAttribution(@NonNull EObject eObject) {
        if (eObject.eIsProxy()) {
            logger.warn((Object)("getAttribution for proxy " + eObject));
            return NullAttribution.INSTANCE;
        }
        EClass eClass = eObject.eClass();
        assert (eClass != null);
        Attribution attribution = this.attributionRegistry.get(eClass);
        if (attribution == null) {
            EClass superClass = eClass;
            while (superClass.getESuperTypes().size() > 0) {
                attribution = this.attributionRegistry.get(superClass = (EClass)superClass.getESuperTypes().get(0));
                if (attribution != null) break;
            }
            if (attribution == null) {
                attribution = NullAttribution.INSTANCE;
            }
            this.attributionRegistry.put((EClassifier)eClass, attribution);
        }
        return attribution;
    }

    @Override
    public @Nullable Type getClassContext() {
        return null;
    }

    @Override
    public @Nullable Element getElementContext() {
        return this.getClassContext();
    }

    protected @NonNull String getDoSetupMessage() {
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            return "";
        }
        String doSetup = this.environmentFactory.getDoSetupName(this.uri);
        if (doSetup == null) {
            return "";
        }
        return "\n\tMake sure " + doSetup + " has been called.";
    }

    @Override
    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull ExpressionInOCL getExpression(@NonNull CSResource resource) throws ParserException {
        Element pivotElement;
        EList contents = resource.getContents();
        int size = contents.size();
        if (size < 1) {
            throw new ParserException("Missing parse returns");
        }
        if (size > 1) {
            throw new ParserException("Extra parse returns");
        }
        EObject csObject = (EObject)contents.get(0);
        if (csObject instanceof Pivotable && (pivotElement = ((Pivotable)csObject).getPivot()) instanceof ExpressionInOCL) {
            return (ExpressionInOCL)pivotElement;
        }
        throw new ParserException("Non-expression ignored");
    }

    public @Nullable Type getInstanceContext() {
        return null;
    }

    @Override
    public @NonNull PivotMetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    protected @NonNull String getRole() {
        if (this.rootElement instanceof LanguageExpression) {
            return PivotUtilInternal.getSpecificationRole((LanguageExpression)this.rootElement);
        }
        return "\u00abunknown\u00bb";
    }

    @Override
    public @Nullable Element getRootElement() {
        return this.rootElement;
    }

    @Override
    public void initialize(@NonNull Base2ASConversion conversion, @NonNull ExpressionInOCL expression) {
    }

    @Override
    public @NonNull ExpressionInOCL parse(@Nullable EObject owner, @NonNull String expression) throws ParserException {
        CSResource resource = null;
        try {
            resource = this.createBaseResource(expression);
            String role = this.getRole();
            String contextName = NameUtil.qualifiedNameFor(this.getMessageContext());
            String invalidMessage = StringUtil.bind(PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, role, contextName, expression.trim());
            PivotUtil.checkResourceErrors(invalidMessage, resource);
            ExpressionInOCL expressionInOCL = this.getExpression(resource);
            expressionInOCL.setBody(expression);
            ExpressionInOCL expressionInOCL2 = expressionInOCL;
            return expressionInOCL2;
        }
        catch (IOException e) {
            @NonNull ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
            InvalidLiteralExp invalidValueBody = this.getMetamodelManager().createInvalidExpression();
            PivotUtil.setBody(specification, invalidValueBody, null);
            ExpressionInOCL expressionInOCL = specification;
            return expressionInOCL;
        }
        finally {
            if (resource != null) {
                resource.unload();
                ResourceSet resourceSet = resource.getResourceSet();
                if (resourceSet != null) {
                    resourceSet.getResources().remove((Object)resource);
                }
                EnvironmentFactoryAdapter.disposeAll(resource);
            }
        }
    }

    protected Element getMessageContext() {
        return this.rootElement != null ? (Element)this.rootElement.eContainer() : this.getClassContext();
    }

    @Override
    public void setRootElement(@Nullable Element rootElement) {
        this.rootElement = rootElement;
    }
}

