/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.DTreeRouter;

public class DForestRouter
extends BendpointConnectionRouter
implements OrthogonalRouter {
    private final Map<AnchorKey, DTreeRouter> connections = new HashMap<AnchorKey, DTreeRouter>();
    private final Map<AnchorKey, Boolean> trunkVertexes = new HashMap<AnchorKey, Boolean>();

    public void remove(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        DTreeRouter connectionRouter = this.getSubRouter(conn);
        if (connectionRouter != null) {
            connectionRouter.remove(conn);
        }
        super.remove(conn);
    }

    public DTreeRouter getSubRouter(Connection conn) {
        AnchorKey connectionKey;
        DTreeRouter connectionRouter;
        if (conn.getTargetAnchor() == null) {
            return null;
        }
        String hint = "base";
        if (conn instanceof ITreeConnection) {
            hint = ((ITreeConnection)conn).getHint();
        }
        if ((connectionRouter = this.connections.get(connectionKey = new AnchorKey(conn.getTargetAnchor(), hint))) == null) {
            DTreeRouter oldConnectionRouter = null;
            if (!"base".equals(hint)) {
                oldConnectionRouter = this.getSubRouterWithHint(hint);
            }
            if (connectionRouter == null) {
                connectionRouter = new DTreeRouter();
                if (oldConnectionRouter != null) {
                    try {
                        connectionRouter.setTrunkLocation(conn, oldConnectionRouter.getTrunkLocation(conn));
                    }
                    catch (NullPointerException nullPointerException) {
                        connectionRouter.setTrunkOrientation(oldConnectionRouter.getTrunkOrientation());
                        connectionRouter.setTrunkVertex(oldConnectionRouter.getTrunkVertex());
                    }
                }
                for (DTreeRouter obj : this.connections.values()) {
                    if (!(obj instanceof DTreeRouter)) continue;
                    obj.remove(conn);
                }
            }
            this.connections.put(connectionKey, connectionRouter);
        }
        return connectionRouter;
    }

    private DTreeRouter getSubRouterWithHint(String hint) {
        for (AnchorKey key : this.connections.keySet()) {
            if (!hint.equals(key.getQualifier())) continue;
            return this.connections.get(key);
        }
        return null;
    }

    public void route(Connection conn) {
        this.internalRoute(conn);
    }

    private void internalRoute(Connection conn) {
        if (conn != null) {
            if (conn.getTargetAnchor().getOwner() == null || conn.getSourceAnchor().getOwner() == null) {
                PointList points = conn.getPoints();
                points.removeAllPoints();
                Point delta = this.getFreeformViewport((IFigure)conn).getViewLocation();
                Point ref1 = conn.getTargetAnchor().getReferencePoint().getCopy();
                Point ref2 = conn.getSourceAnchor().getReferencePoint().getCopy();
                PrecisionPoint precisePt = new PrecisionPoint();
                precisePt.setLocation(conn.getSourceAnchor().getLocation(ref1).getTranslated(delta));
                points.addPoint((Point)precisePt);
                precisePt.setLocation(conn.getTargetAnchor().getLocation(ref2).getTranslated(delta));
                points.addPoint((Point)precisePt);
                conn.setPoints(points);
                return;
            }
            DTreeRouter treeRouter = this.getSubRouter(conn);
            if (treeRouter != null) {
                Dimension trunk = treeRouter.getTrunkVertex();
                if (trunk != null) {
                    AnchorKey trunkKey = new AnchorKey(conn.getTargetAnchor(), trunk);
                    this.trunkVertexes.remove(trunkKey);
                }
                treeRouter.route(conn);
                trunk = treeRouter.getTrunkVertex();
                Dimension adjustedTrunk = this.accountForTrunkOverlap(trunk, conn);
                if (!adjustedTrunk.equals((Object)trunk)) {
                    treeRouter.setTrunkVertex(adjustedTrunk);
                    treeRouter.invalidate(conn);
                }
            }
        }
    }

    private FreeformViewport getFreeformViewport(IFigure figure) {
        IFigure current = figure;
        while (!(current instanceof FreeformViewport) && current != null) {
            current = current.getParent();
        }
        return (FreeformViewport)current;
    }

    private Dimension accountForTrunkOverlap(Dimension trunk, Connection conn) {
        Dimension result = trunk;
        if (conn.getTargetAnchor() != null && conn.getTargetAnchor().getOwner() == null) {
            AnchorKey trunkKey = new AnchorKey(conn.getTargetAnchor(), trunk);
            int ownerExt = conn.getTargetAnchor().getOwner().getBounds().width / 2;
            int trunkExt = trunk.width;
            if (conn instanceof ITreeConnection && ((ITreeConnection)conn).getOrientation() == ITreeConnection.Orientation.VERTICAL) {
                ownerExt = conn.getTargetAnchor().getOwner().getBounds().height / 2;
                trunkExt = trunk.height;
            }
            if (this.trunkVertexes.get(trunkKey) == null || Math.abs(trunkExt) > ownerExt) {
                this.trunkVertexes.put(trunkKey, Boolean.TRUE);
                result = trunk;
            } else {
                Dimension newTrunk = new Dimension(trunk);
                if (((ITreeConnection)conn).getOrientation() == ITreeConnection.Orientation.HORIZONTAL) {
                    newTrunk.expand(10, 0);
                } else {
                    newTrunk.expand(0, 10);
                }
                result = this.accountForTrunkOverlap(newTrunk, conn);
            }
        }
        return result;
    }

    public void invalidate(Connection conn) {
        if (conn != null && conn.getSourceAnchor() != null && conn.getTargetAnchor() != null) {
            super.invalidate(conn);
        }
    }

    private static class AnchorKey {
        private final ConnectionAnchor anchor;
        private final Object qualifier;

        AnchorKey(ConnectionAnchor anchor, Object qualifier) {
            this.anchor = anchor;
            this.qualifier = qualifier;
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof AnchorKey) {
                AnchorKey hashKey = (AnchorKey)object;
                ConnectionAnchor hkA1 = hashKey.getAnchor();
                Object hkA2 = hashKey.getQualifier();
                isEqual = hkA1.equals(this.anchor) && hkA2.equals(this.qualifier);
            }
            return isEqual;
        }

        public ConnectionAnchor getAnchor() {
            return this.anchor;
        }

        public Object getQualifier() {
            return this.qualifier;
        }

        public int hashCode() {
            return this.anchor.hashCode() ^ this.qualifier.hashCode();
        }
    }
}

