/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal.util;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.universal.util.Log;
import org.eclipse.ui.internal.intro.universal.util.StringUtil;
import org.osgi.framework.Bundle;

public class BundleUtil {
    private static String NL_TAG = "$nl$/";

    public static boolean bundleHasValidState(Bundle bundle) {
        if (bundle == null || bundle.getState() == 1 || bundle.getState() == 2) {
            if (bundle == null) {
                Log.error("Universal Welcome tried accessing a NULL bundle.", null);
            } else {
                String msg = StringUtil.concat("Universal Welcome tried accessing Bundle: ", BundleUtil.getBundleHeader(bundle, "Bundle-Name"), " vendor: ", BundleUtil.getBundleHeader(bundle, "Bundle-Vendor"), " bundle state: ", String.valueOf(bundle.getState()));
                Log.error(msg, null);
            }
            return false;
        }
        return true;
    }

    public static String getBundleHeader(Bundle bundle, String key) {
        return (String)bundle.getHeaders().get(key);
    }

    public static Bundle getBundleFromConfigurationElement(IConfigurationElement cfg) {
        return Platform.getBundle((String)cfg.getNamespaceIdentifier());
    }

    public static String getResourceLocation(String resource, IConfigurationElement element) {
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(element);
        return BundleUtil.getResolvedResourceLocation(resource, bundle, false);
    }

    public static String getResolvedResourceLocation(String resource, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return BundleUtil.getResolvedResourceLocation(resource, bundle, true);
    }

    public static String getResolvedResourceLocation(String resource, Bundle bundle) {
        return BundleUtil.getResolvedResourceLocation(resource, bundle, true);
    }

    public static String getResolvedResourceLocation(String base, String resource, Bundle bundle) {
        if (resource == null) {
            return null;
        }
        String fullResource = IPath.fromOSString((String)base).append(resource).toString();
        String resolvedResource = BundleUtil.getResolvedResourceLocation(fullResource, bundle, true);
        if (resolvedResource.equals(fullResource)) {
            return resource;
        }
        return resolvedResource;
    }

    public static String getResolvedResourceLocation(String resource, Bundle bundle, boolean forceNLResolve) {
        if (resource == null) {
            return null;
        }
        if (bundle == null || !BundleUtil.bundleHasValidState(bundle)) {
            return resource;
        }
        URL localLocation = null;
        try {
            IPath resourcePath;
            Object copyResource = resource;
            if (forceNLResolve && !((String)copyResource).startsWith(NL_TAG)) {
                if (((String)copyResource).startsWith("/") || ((String)copyResource).startsWith("\\")) {
                    copyResource = resource.substring(1);
                }
                copyResource = NL_TAG + (String)copyResource;
            }
            if ((localLocation = FileLocator.find((Bundle)bundle, (IPath)(resourcePath = IPath.fromOSString((String)copyResource)), null)) == null) {
                String msg = StringUtil.concat("Could not find resource: ", resource, " in ", BundleUtil.getBundleHeader(bundle, "Bundle-Name"));
                Log.warning(msg);
                return resource;
            }
            return BundleUtil.toExternalForm(localLocation);
        }
        catch (Exception e) {
            String msg = StringUtil.concat("Failed to load resource: ", resource, " from ", BundleUtil.getBundleHeader(bundle, "Bundle-Name"));
            Log.error(msg, e);
            return resource;
        }
    }

    private static String toExternalForm(URL localURL) {
        try {
            localURL = FileLocator.toFileURL((URL)localURL);
            Object result = localURL.toExternalForm();
            if (((String)result).startsWith("file:/") && !((String)result).startsWith("file:///")) {
                result = "file:///" + ((String)result).substring(6);
            }
            return result;
        }
        catch (IOException e) {
            String msg = "Failed to resolve URL: " + localURL.toString();
            Log.error(msg, e);
            return localURL.toString();
        }
    }

    public static URL getResourceAsURL(String resource, String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        return FileLocator.find((Bundle)bundle, (IPath)IPath.fromOSString((String)resource), null);
    }

    public static String getResolvedBundleLocation(Bundle bundle) {
        URL bundleLocation;
        block3: {
            try {
                bundleLocation = bundle.getEntry("");
                if (bundleLocation != null) break block3;
                return null;
            }
            catch (IllegalStateException e) {
                Log.error("Failed to access bundle: " + bundle.getSymbolicName(), e);
                return null;
            }
        }
        return BundleUtil.toExternalForm(bundleLocation);
    }

    public static String getResolvedBundleLocation(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        return BundleUtil.getResolvedBundleLocation(bundle);
    }
}

