/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.fsm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;

public class FSMComposition {
    private Map<List<Location>, Location> stateMap;
    private Integer currentStateId;
    private List<FSM<Location, Edge>> fsmList;
    private FSMImpl cFSM;
    private Set<String> alphabet;
    private Set<Edge> visitedEdges;
    private Set<Location> visitedLocations;

    public FSMImpl compute(List<FSM<Location, Edge>> fsms) {
        this.stateMap = new HashMap<List<Location>, Location>();
        this.currentStateId = 0;
        this.cFSM = new FSMImpl();
        this.visitedEdges = new HashSet<Edge>();
        this.visitedLocations = new HashSet<Location>();
        this.fsmList = fsms;
        this.alphabet = new HashSet<String>();
        for (FSM<Location, Edge> fsm : fsms) {
            this.alphabet.addAll(fsm.getAlphabet());
        }
        ArrayList<Location> initialState = new ArrayList<Location>();
        int fsmId = 0;
        while (fsmId < this.fsmList.size()) {
            initialState.add(fsmId, this.fsmList.get(fsmId).getInitial());
            ++fsmId;
        }
        Location stateLocation = this.getLocation(initialState);
        this.cFSM.setInitial(stateLocation);
        int fsmId2 = 0;
        while (fsmId2 < this.fsmList.size()) {
            for (String uEvent : this.fsmList.get(fsmId2).getUncontrollable()) {
                this.cFSM.addUncontrollable(uEvent);
            }
            for (String cEvent : this.fsmList.get(fsmId2).getControllable()) {
                this.cFSM.addControllable(cEvent);
            }
            ++fsmId2;
        }
        this.dfsTraversal(initialState);
        return this.cFSM;
    }

    private void dfsTraversal(List<Location> initialState) {
        Stack<List<Location>> stack = new Stack<List<Location>>();
        stack.push(initialState);
        while (!stack.isEmpty()) {
            List state = (List)stack.pop();
            if (!this.isVisited(this.getLocation(state))) {
                this.visit(state);
            }
            LinkedList<String> queue = new LinkedList<String>();
            queue.addAll(FSMComposition.enabled(this.fsmList, state));
            while (!queue.isEmpty()) {
                String a = (String)queue.remove();
                List<Location> targetState = FSMComposition.getEdgeTarget(this.fsmList, state, a);
                Edge e = new Edge(this.getLocation(state), a, this.getLocation(targetState));
                if (this.isVisited(e)) continue;
                this.visit(e);
                if (this.isVisited(this.getLocation(targetState))) continue;
                stack.push(targetState);
            }
        }
    }

    private void visit(List<Location> state) {
        this.visitedLocations.add(this.getLocation(state));
        this.cFSM.addLocation(this.stateMap.get(state));
    }

    private void visit(Edge e) {
        this.visitedEdges.add(e);
        this.cFSM.addEdge(e);
    }

    private Location getLocation(List<Location> state) {
        if (!this.stateMap.containsKey(state)) {
            this.currentStateId = this.currentStateId + 1;
            this.stateMap.put(state, new Location("s" + String.valueOf(this.currentStateId)));
        }
        return this.stateMap.get(state);
    }

    private boolean isVisited(Location location) {
        return this.visitedLocations.contains(location);
    }

    private boolean isVisited(Edge e) {
        return this.visitedEdges.contains(e);
    }

    public static Set<String> enabled(List<FSM<Location, Edge>> fsmList, List<Location> state) {
        HashSet<String> locallyEnabled = new HashSet<String>();
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            FSM<Location, Edge> fsm = fsmList.get(fsmId);
            for (Edge e : fsm.outgoingEdgesOf(state.get(fsmId))) {
                locallyEnabled.add(e.getEvent());
            }
            ++fsmId;
        }
        HashSet<String> globallyEnabled = new HashSet<String>();
        for (String event : locallyEnabled) {
            if (!FSMComposition.isEnabled(fsmList, state, event)) continue;
            globallyEnabled.add(event);
        }
        return globallyEnabled;
    }

    public static Set<String> enabled(FSM<Location, Edge> fsm, Location state) {
        HashSet<String> enabled = new HashSet<String>();
        for (Edge e : fsm.outgoingEdgesOf(state)) {
            enabled.add(e.getEvent());
        }
        return enabled;
    }

    public static boolean isEnabled(List<FSM<Location, Edge>> fsmList, List<Location> state, String event) {
        boolean found = false;
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            FSM<Location, Edge> fsm = fsmList.get(fsmId);
            Location loc = state.get(fsmId);
            if (fsm.getAlphabet().contains(event)) {
                if (FSMComposition.isEnabled(fsm, loc, event)) {
                    found = true;
                } else {
                    return false;
                }
            }
            ++fsmId;
        }
        return found;
    }

    public static boolean isEnabled(FSM<Location, Edge> fsm, Location location, String event) {
        for (Edge e : fsm.outgoingEdgesOf(location)) {
            if (!fsm.getEvent(e).equals(event)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMarked(List<FSM<Location, Edge>> fsmList, List<Location> state) {
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            FSM<Location, Edge> fsm = fsmList.get(fsmId);
            if (!fsm.isMarked(state.get(fsmId))) {
                return false;
            }
            ++fsmId;
        }
        return true;
    }

    public static boolean isInvisible(List<FSM<Location, Edge>> fsmList, List<Location> state, String event) {
        List<Location> targetState = FSMComposition.getEdgeTarget(fsmList, state, event);
        return FSMComposition.isMarked(fsmList, state) == FSMComposition.isMarked(fsmList, targetState);
    }

    public static List<Location> getEdgeTarget(List<FSM<Location, Edge>> fsmList, List<Location> state, String event) {
        assert (FSMComposition.isEnabled(fsmList, state, event));
        ArrayList<Location> targetState = new ArrayList<Location>(state);
        int fsmId = 0;
        while (fsmId < fsmList.size()) {
            FSM<Location, Edge> fsm = fsmList.get(fsmId);
            Location loc = state.get(fsmId);
            for (Edge e : fsm.outgoingEdgesOf(loc)) {
                if (!fsm.getEvent(e).equals(event)) continue;
                targetState.set(fsmId, (Location)fsm.getEdgeTarget(e));
                break;
            }
            ++fsmId;
        }
        return targetState;
    }
}

