/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class ScalingBlock
extends DialogBlock {
    private final DataBindingContext bindings;
    private final PrintOptions options;

    ScalingBlock(DialogBlock.IDialogUnitConverter dluConverter, DataBindingContext bindings, PrintOptions options) {
        super(dluConverter);
        this.bindings = bindings;
        this.options = options;
    }

    @Override
    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        Group result = this.group(parent, DiagramUIPrintingMessages.JPSPrintDialog_Scaling);
        ScalingBlock.layout((Composite)result, 5);
        Button adjustRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_Adjust);
        this.layoutSpanHorizontal((Control)adjustRadio, 2);
        Text textScale = this.text((Composite)result, 20);
        this.layoutSpanHorizontal(this.blank((Composite)result), 2);
        final IObservableValue scalingValue = BeanProperties.value(PrintOptions.class, (String)PrintOptions.PROPERTY_PERCENT_SCALING).observe(realm, (Object)this.options);
        this.bindings.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)adjustRadio), scalingValue);
        this.bindings.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textScale), BeanProperties.value(PrintOptions.class, (String)PrintOptions.PROPERTY_SCALE_FACTOR).observe(realm, (Object)this.options));
        this.bindings.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)textScale), scalingValue);
        Button fitToRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_FitTo);
        ComputedValue<Boolean> fitToValue = new ComputedValue<Boolean>(realm){

            protected Boolean calculate() {
                return (Boolean)scalingValue.getValue() == false;
            }
        };
        this.bindings.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)fitToRadio), (IObservableValue)fitToValue);
        this.layoutHorizontalIndent(this.layoutAlignRight((Control)this.label((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_PagesWide)));
        Text textWidget = this.text((Composite)result, 20);
        this.layoutHorizontalIndent(this.layoutAlignRight((Control)this.label((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_PagesTall)));
        Text textTall = this.text((Composite)result, 20);
        this.bindings.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textWidget), BeanProperties.value(PrintOptions.class, (String)PrintOptions.PROPERTY_FIT_TO_WIDTH).observe(realm, (Object)this.options));
        this.bindings.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)textWidget), (IObservableValue)fitToValue);
        this.bindings.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)textTall), BeanProperties.value(PrintOptions.class, (String)PrintOptions.PROPERTY_FIT_TO_HEIGHT).observe(realm, (Object)this.options));
        this.bindings.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)textTall), (IObservableValue)fitToValue);
        return result;
    }

    @Override
    public void dispose() {
    }
}

