/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.StringOutputStream;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.EnvironmentVariablesPreferencePage;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.Messages;
import org.eclipse.linuxtools.systemtap.structures.runnable.StringStreamGobbler;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.tools.launch.core.factory.LinuxtoolsProcessFactory;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class TapsetParser
extends Job {
    private static AtomicBoolean displayingCredentialDialog = new AtomicBoolean(false);

    protected TapsetParser(String jobTitle) {
        super(jobTitle);
    }

    protected void canceling() {
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    protected IStatus createStatus(int severity) {
        IPreferenceStore ps = IDEPlugin.getDefault().getPreferenceStore();
        return this.createStatus(severity, switch (severity) {
            case 4 -> {
                if (ps.getBoolean("RemoteProbes")) {
                    IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
                    yield MessageFormat.format(Messages.TapsetParser_ErrorCannotRunRemoteStap, p.getString("scpuser"), p.getString("host"));
                }
                yield Messages.TapsetParser_ErrorCannotRunStap;
            }
            default -> "";
        });
    }

    protected IStatus createStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.linuxtools.systemtap.ui.ide", message);
    }

    protected String runStap(String[] options, String probe, boolean getErrors) {
        int i;
        int size;
        String[] args = null;
        String[] tapsets = IDEPlugin.getDefault().getPreferenceStore().getString("TapsetPreference").split(File.pathSeparator);
        boolean noTapsets = tapsets[0].trim().isEmpty();
        boolean noOptions = options[0].trim().isEmpty();
        boolean remote = IDEPlugin.getDefault().getPreferenceStore().getBoolean("RemoteProbes");
        int n = size = probe != null ? 2 : 1;
        if (!noTapsets) {
            size += tapsets.length << 1;
        }
        if (!noOptions) {
            size += options.length;
        }
        args = new String[size];
        args[0] = "stap";
        if (probe != null) {
            Object object = args[size - 1] = !remote ? probe : "'" + probe + "'";
        }
        if (!noTapsets) {
            for (i = 0; i < tapsets.length; ++i) {
                args[1 + 2 * i] = "-I";
                args[2 + 2 * i] = tapsets[i];
            }
        }
        if (!noOptions) {
            int s;
            int n2 = s = noTapsets ? 1 : 1 + tapsets.length * 2;
            for (i = 0; i < options.length; ++i) {
                args[s + i] = options[i];
            }
        }
        if (!remote) {
            try {
                return this.runLocalStap(args, getErrors);
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.runRemoteStap(args, getErrors);
    }

    protected int verifyRunResult(String result) {
        if (result == null) {
            return 4;
        }
        if (result.isEmpty()) {
            return 8;
        }
        return 0;
    }

    private String runLocalStap(String[] args, boolean getErrors) throws IOException {
        Process process = RuntimeProcessFactory.getFactory().exec(args, EnvironmentVariablesPreferencePage.getEnvironmentVariables(), null);
        if (process == null) {
            return null;
        }
        StringStreamGobbler gobbler = new StringStreamGobbler(process.getInputStream());
        StringStreamGobbler egobbler = new StringStreamGobbler(process.getErrorStream());
        gobbler.start();
        egobbler.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            process.destroy();
        }
        gobbler.stop();
        egobbler.stop();
        if (!getErrors) {
            return gobbler.getOutput().toString();
        }
        return egobbler.getOutput().toString();
    }

    private String runRemoteStap(String[] args, boolean getErrors) {
        int attemptsLeft = 3;
        while (true) {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    return "";
                }
                return this.runRemoteStapAttempt(args, getErrors);
            }
            catch (JSchException e) {
                if (e.getCause() instanceof ConnectException && --attemptsLeft != 0) continue;
                this.askIfEditCredentials();
                return "";
            }
            break;
        }
    }

    private String runRemoteStapAttempt(String[] args, boolean getErrors) throws JSchException {
        int port;
        String password;
        String host;
        StringOutputStream str = new StringOutputStream();
        StringOutputStream strErr = new StringOutputStream();
        IPreferenceStore p = ConsoleLogPlugin.getDefault().getPreferenceStore();
        String user = p.getString("scpuser");
        Channel channel = LinuxtoolsProcessFactory.execRemoteAndWait((String[])args, (OutputStream)str, (OutputStream)strErr, (String)user, (String)(host = p.getString("host")), (String)(password = p.getString("scppassword")), (int)(port = p.getInt("port")), (String[])EnvironmentVariablesPreferencePage.getEnvironmentVariables());
        if (channel == null) {
            return null;
        }
        channel.getSession().disconnect();
        channel.disconnect();
        return (!getErrors ? str : strErr).toString();
    }

    private void askIfEditCredentials() {
        if (displayingCredentialDialog.compareAndSet(false, true)) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageBox dialog = new MessageBox(shell, 196);
                dialog.setText(Messages.TapsetParser_RemoteCredentialErrorTitle);
                dialog.setMessage(Messages.TapsetParser_RemoteCredentialErrorMessage);
                if (dialog.open() == 64) {
                    String pageID = "org.eclipse.linuxtools.systemtap.prefs.consoleLog";
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageID, (String[])new String[]{pageID}, null).open();
                }
                displayingCredentialDialog.set(false);
            });
        }
    }
}

