
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link SecretBind}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSecretBind.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableSecretBind implements SecretBind {
  private final SecretFile file;
  private final String secretId;
  private final String secretName;

  private ImmutableSecretBind(
      SecretFile file,
      String secretId,
      String secretName) {
    this.file = file;
    this.secretId = secretId;
    this.secretName = secretName;
  }

  /**
   * @return The value of the {@code file} attribute
   */
  @JsonProperty("File")
  @Override
  public SecretFile file() {
    return file;
  }

  /**
   * @return The value of the {@code secretId} attribute
   */
  @JsonProperty("SecretID")
  @Override
  public String secretId() {
    return secretId;
  }

  /**
   * @return The value of the {@code secretName} attribute
   */
  @JsonProperty("SecretName")
  @Override
  public String secretName() {
    return secretName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecretBind#file() file} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for file
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSecretBind withFile(SecretFile value) {
    if (this.file == value) return this;
    SecretFile newValue = Objects.requireNonNull(value, "file");
    return new ImmutableSecretBind(newValue, this.secretId, this.secretName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecretBind#secretId() secretId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secretId
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSecretBind withSecretId(String value) {
    String newValue = Objects.requireNonNull(value, "secretId");
    if (this.secretId.equals(newValue)) return this;
    return new ImmutableSecretBind(this.file, newValue, this.secretName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SecretBind#secretName() secretName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for secretName
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableSecretBind withSecretName(String value) {
    String newValue = Objects.requireNonNull(value, "secretName");
    if (this.secretName.equals(newValue)) return this;
    return new ImmutableSecretBind(this.file, this.secretId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSecretBind} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSecretBind
        && equalsByValue((ImmutableSecretBind) another);
  }

  private boolean equalsByValue(ImmutableSecretBind another) {
    return file.equals(another.file)
        && secretId.equals(another.secretId)
        && secretName.equals(another.secretName);
  }

  /**
   * Computes a hash code from attributes: {@code file}, {@code secretId}, {@code secretName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + file.hashCode();
    h += (h << 5) + secretId.hashCode();
    h += (h << 5) + secretName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SecretBind} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SecretBind{"
        + "file=" + file
        + ", secretId=" + secretId
        + ", secretName=" + secretName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SecretBind} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SecretBind instance
   */
  public static ImmutableSecretBind copyOf(SecretBind instance) {
    if (instance instanceof ImmutableSecretBind) {
      return (ImmutableSecretBind) instance;
    }
    return ImmutableSecretBind.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSecretBind ImmutableSecretBind}.
   * <pre>
   * ImmutableSecretBind.builder()
   *    .file(org.mandas.docker.client.messages.swarm.SecretFile) // required {@link SecretBind#file() file}
   *    .secretId(String) // required {@link SecretBind#secretId() secretId}
   *    .secretName(String) // required {@link SecretBind#secretName() secretName}
   *    .build();
   * </pre>
   * @return A new ImmutableSecretBind builder
   */
  public static ImmutableSecretBind.Builder builder() {
    return new ImmutableSecretBind.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSecretBind ImmutableSecretBind}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements SecretBind.Builder {
    private static final long INIT_BIT_FILE = 0x1L;
    private static final long INIT_BIT_SECRET_ID = 0x2L;
    private static final long INIT_BIT_SECRET_NAME = 0x4L;
    private long initBits = 0x7L;

    private SecretFile file;
    private String secretId;
    private String secretName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SecretBind} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SecretBind instance) {
      Objects.requireNonNull(instance, "instance");
      this.file(instance.file());
      this.secretId(instance.secretId());
      this.secretName(instance.secretName());
      return this;
    }

    /**
     * Initializes the value for the {@link SecretBind#file() file} attribute.
     * @param file The value for file 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("File")
    public final Builder file(SecretFile file) {
      this.file = Objects.requireNonNull(file, "file");
      initBits &= ~INIT_BIT_FILE;
      return this;
    }

    /**
     * Initializes the value for the {@link SecretBind#secretId() secretId} attribute.
     * @param secretId The value for secretId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SecretID")
    public final Builder secretId(String secretId) {
      this.secretId = Objects.requireNonNull(secretId, "secretId");
      initBits &= ~INIT_BIT_SECRET_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SecretBind#secretName() secretName} attribute.
     * @param secretName The value for secretName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SecretName")
    public final Builder secretName(String secretName) {
      this.secretName = Objects.requireNonNull(secretName, "secretName");
      initBits &= ~INIT_BIT_SECRET_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSecretBind ImmutableSecretBind}.
     * @return An immutable instance of SecretBind
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSecretBind build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSecretBind(file, secretId, secretName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FILE) != 0) attributes.add("file");
      if ((initBits & INIT_BIT_SECRET_ID) != 0) attributes.add("secretId");
      if ((initBits & INIT_BIT_SECRET_NAME) != 0) attributes.add("secretName");
      return "Cannot build SecretBind, some of required attributes are not set " + attributes;
    }
  }
}
