/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Healthcheck;

final class ImmutableHealthcheck
implements Healthcheck {
    @Nullable
    private final List<String> test;
    @Nullable
    private final Long interval;
    @Nullable
    private final Long timeout;
    @Nullable
    private final Integer retries;
    @Nullable
    private final Long startPeriod;

    private ImmutableHealthcheck(@Nullable List<String> test, @Nullable Long interval, @Nullable Long timeout, @Nullable Integer retries, @Nullable Long startPeriod) {
        this.test = test;
        this.interval = interval;
        this.timeout = timeout;
        this.retries = retries;
        this.startPeriod = startPeriod;
    }

    @Override
    @JsonProperty(value="Test")
    @Nullable
    public List<String> test() {
        return this.test;
    }

    @Override
    @JsonProperty(value="Interval")
    @Nullable
    public Long interval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="Timeout")
    @Nullable
    public Long timeout() {
        return this.timeout;
    }

    @Override
    @JsonProperty(value="Retries")
    @Nullable
    public Integer retries() {
        return this.retries;
    }

    @Override
    @JsonProperty(value="StartPeriod")
    @Nullable
    public Long startPeriod() {
        return this.startPeriod;
    }

    public final ImmutableHealthcheck withTest(String ... elements) {
        if (elements == null) {
            return new ImmutableHealthcheck(null, this.interval, this.timeout, this.retries, this.startPeriod);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHealthcheck.createUnmodifiableList(false, ImmutableHealthcheck.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableHealthcheck(newValue, this.interval, this.timeout, this.retries, this.startPeriod);
    }

    public final ImmutableHealthcheck withTest(@Nullable Iterable<String> elements) {
        if (this.test == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHealthcheck.createUnmodifiableList(false, ImmutableHealthcheck.createSafeList(elements, true, false));
        return new ImmutableHealthcheck(newValue, this.interval, this.timeout, this.retries, this.startPeriod);
    }

    public final ImmutableHealthcheck withInterval(@Nullable Long value) {
        if (Objects.equals(this.interval, value)) {
            return this;
        }
        return new ImmutableHealthcheck(this.test, value, this.timeout, this.retries, this.startPeriod);
    }

    public final ImmutableHealthcheck withTimeout(@Nullable Long value) {
        if (Objects.equals(this.timeout, value)) {
            return this;
        }
        return new ImmutableHealthcheck(this.test, this.interval, value, this.retries, this.startPeriod);
    }

    public final ImmutableHealthcheck withRetries(@Nullable Integer value) {
        if (Objects.equals(this.retries, value)) {
            return this;
        }
        return new ImmutableHealthcheck(this.test, this.interval, this.timeout, value, this.startPeriod);
    }

    public final ImmutableHealthcheck withStartPeriod(@Nullable Long value) {
        if (Objects.equals(this.startPeriod, value)) {
            return this;
        }
        return new ImmutableHealthcheck(this.test, this.interval, this.timeout, this.retries, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHealthcheck && this.equalTo(0, (ImmutableHealthcheck)another);
    }

    private boolean equalTo(int synthetic, ImmutableHealthcheck another) {
        return Objects.equals(this.test, another.test) && Objects.equals(this.interval, another.interval) && Objects.equals(this.timeout, another.timeout) && Objects.equals(this.retries, another.retries) && Objects.equals(this.startPeriod, another.startPeriod);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.test);
        h += (h << 5) + Objects.hashCode(this.interval);
        h += (h << 5) + Objects.hashCode(this.timeout);
        h += (h << 5) + Objects.hashCode(this.retries);
        h += (h << 5) + Objects.hashCode(this.startPeriod);
        return h;
    }

    public String toString() {
        return "Healthcheck{test=" + String.valueOf(this.test) + ", interval=" + this.interval + ", timeout=" + this.timeout + ", retries=" + this.retries + ", startPeriod=" + this.startPeriod + "}";
    }

    public static ImmutableHealthcheck copyOf(Healthcheck instance) {
        if (instance instanceof ImmutableHealthcheck) {
            return (ImmutableHealthcheck)instance;
        }
        return ImmutableHealthcheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements Healthcheck.Builder {
        private List<String> test = null;
        private Long interval;
        private Long timeout;
        private Integer retries;
        private Long startPeriod;

        private Builder() {
        }

        public final Builder from(Healthcheck instance) {
            Long startPeriodValue;
            Integer retriesValue;
            Long timeoutValue;
            Long intervalValue;
            Objects.requireNonNull(instance, "instance");
            List<String> testValue = instance.test();
            if (testValue != null) {
                this.addAllTest(testValue);
            }
            if ((intervalValue = instance.interval()) != null) {
                this.interval(intervalValue);
            }
            if ((timeoutValue = instance.timeout()) != null) {
                this.timeout(timeoutValue);
            }
            if ((retriesValue = instance.retries()) != null) {
                this.retries(retriesValue);
            }
            if ((startPeriodValue = instance.startPeriod()) != null) {
                this.startPeriod(startPeriodValue);
            }
            return this;
        }

        public final Builder test(String element) {
            if (this.test == null) {
                this.test = new ArrayList<String>();
            }
            this.test.add(Objects.requireNonNull(element, "test element"));
            return this;
        }

        public final Builder test(String ... elements) {
            if (this.test == null) {
                this.test = new ArrayList<String>();
            }
            for (String element : elements) {
                this.test.add(Objects.requireNonNull(element, "test element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Test")
        public final Builder test(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.test = null;
                return this;
            }
            this.test = new ArrayList<String>();
            return this.addAllTest(elements);
        }

        public final Builder addAllTest(Iterable<String> elements) {
            Objects.requireNonNull(elements, "test element");
            if (this.test == null) {
                this.test = new ArrayList<String>();
            }
            for (String element : elements) {
                this.test.add(Objects.requireNonNull(element, "test element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Interval")
        public final Builder interval(@Nullable Long interval) {
            this.interval = interval;
            return this;
        }

        @Override
        @JsonProperty(value="Timeout")
        public final Builder timeout(@Nullable Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        @JsonProperty(value="Retries")
        public final Builder retries(@Nullable Integer retries) {
            this.retries = retries;
            return this;
        }

        @Override
        @JsonProperty(value="StartPeriod")
        public final Builder startPeriod(@Nullable Long startPeriod) {
            this.startPeriod = startPeriod;
            return this;
        }

        @Override
        public ImmutableHealthcheck build() {
            return new ImmutableHealthcheck(this.test == null ? null : ImmutableHealthcheck.createUnmodifiableList(true, this.test), this.interval, this.timeout, this.retries, this.startPeriod);
        }
    }
}

