/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.utils.JSONUtility;

public class DataEntryField {
    private static final String DATA_URI_FIELD = "uri";
    private static final String DATA_PARTICIPANT_ID_FIELD = "participantId";
    public static final String OFFSET_FIELD = "offset";

    public static JsonObject createData(String uri, String participantId) {
        JsonObject data = new JsonObject();
        data.addProperty(DATA_URI_FIELD, uri);
        data.addProperty(DATA_PARTICIPANT_ID_FIELD, participantId);
        return data;
    }

    public static String getUri(Object data) {
        return DataEntryField.getProperty(data, DATA_URI_FIELD);
    }

    public static String getParticipantId(Object data) {
        return DataEntryField.getProperty(data, DATA_PARTICIPANT_ID_FIELD);
    }

    public static String getProperty(Object data, String fieldName) {
        JsonObject json = JSONUtility.toModel(data, JsonObject.class);
        if (json == null) {
            return null;
        }
        JsonElement element = json.get(fieldName);
        return element != null ? element.getAsString() : null;
    }

    public static Integer getPropertyAsInt(Object data, String fieldName) {
        try {
            JsonObject json = JSONUtility.toModel(data, JsonObject.class);
            if (json == null) {
                return null;
            }
            JsonElement element = json.get(fieldName);
            return element != null ? Integer.valueOf(element.getAsInt()) : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Boolean getPropertyAsBoolean(Object data, String fieldName) {
        JsonObject json = JSONUtility.toModel(data, JsonObject.class);
        if (json == null) {
            return null;
        }
        JsonElement element = json.get(fieldName);
        return element != null ? Boolean.valueOf(element.getAsBoolean()) : null;
    }

    public static JsonObject createCompletionData(ICompletionRequest request, String participantId) {
        DOMDocument document = request.getNode().getOwnerDocument();
        JsonObject data = DataEntryField.createData(document.getDocumentURI(), participantId);
        data.addProperty(OFFSET_FIELD, (Number)request.getOffset());
        return data;
    }
}

