/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Locale;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.settings.EnforceQuoteStyle;
import org.eclipse.lemminx.settings.QuoteStyle;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class DTDEntityDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void EntityDeclUnterminated() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!ENTITY copyright \"Copyright W3Schools.\"  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 42, 43, (IXMLErrorCode)DTDErrorCode.EntityDeclUnterminated));
    }

    @Test
    public void EntityNotDeclaredAddToSubset() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n\t<!ENTITY nbsp \"entity-value\">")));
    }

    @Test
    public void EntityNotDeclaredAddToSubsetOneChar() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&a;\r\n</article>";
        Diagnostic d = XMLAssert.d(5, 1, 5, 4, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"a\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n\t<!ENTITY a \"entity-value\">")));
    }

    @Test
    public void EntityNotDeclaredNoPrologNoDoctype() throws Exception {
        String xml = "<article>\r\n\t&nbsp;\r\n</article>";
        Diagnostic d = XMLAssert.d(1, 1, 1, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 0, 0, 0, "<!DOCTYPE article [\r\n\t<!ENTITY nbsp \"entity-value\">\r\n]>\r\n")));
    }

    @Test
    public void EntityNotDeclaredWithPrologNoDoctype() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        Diagnostic d = XMLAssert.d(2, 1, 2, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 38, 0, 38, "\r\n<!DOCTYPE article [\r\n\t<!ENTITY nbsp \"entity-value\">\r\n]>")));
    }

    @Test
    public void EntityNotDeclaredWithPrologWithRootSameLine() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><text1>\n<text2>\n\t&c;\n</text2>\n</text1>";
        Diagnostic d = XMLAssert.d(2, 1, 2, 4, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"c\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(0, 38, 0, 38, "\n<!DOCTYPE text1 [\n\t<!ENTITY c \"entity-value\">\n]>\n")));
    }

    @Test
    public void EntityNotDeclaredDoctypeNoSubset() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article >\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(3, 1, 3, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 18, 1, 18, "[\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void EntityNotDeclaredDoctypeNoSubsetNoSpace() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(3, 1, 3, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 17, 1, 17, " [\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void EntityNotDeclaredDoctypeNoSubsetEndBracketNewLine() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article\n>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(4, 1, 4, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 0, 2, 0, "[\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void Issue862() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article\n>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(4, 1, 4, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article\n>\n<article>\n\t&|nbsp;\n</article>";
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 0, 2, 0, "[\n\t<!ENTITY nbsp \"entity-value\">\n]")));
    }

    @Test
    public void EntityNotDeclaredDoctypeEmptySubset() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article []>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(3, 1, 3, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(1, 19, 1, 19, "\n\t<!ENTITY nbsp \"entity-value\">\n")));
    }

    @Test
    public void EntityNotDeclaredDoctypeEmptySubsetWithNewline() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE article [\n]>\n<article>\n\t&nbsp;\n</article>";
        Diagnostic d = XMLAssert.d(4, 1, 4, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, XMLAssert.ca(d, XMLAssert.te(2, 0, 2, 0, "\t<!ENTITY nbsp \"entity-value\">\n")));
    }

    @Test
    public void EntityNotDeclaredSingleQuotes() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setInsertSpaces(false);
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, settings, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n\t<!ENTITY nbsp 'entity-value'>")));
    }

    @Test
    public void NotationDeclUnterminated() throws Exception {
        String xml = "<?xml version = \"1.0\"?>\r\n<!DOCTYPE Person [\r\n\t<!NOTATION png PUBLIC \"PNG 1.0\" \"image/png\"  \r\n]>\r\n<Person Likes=\"\" />";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 44, 45, (IXMLErrorCode)DTDErrorCode.NotationDeclUnterminated));
    }

    @Test
    public void EntityNotDeclared() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(5, 1, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared));
    }

    @Test
    public void EntityNotDeclaredRespectsIndentSettings1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(6);
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, settings, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n      <!ENTITY nbsp 'entity-value'>")));
    }

    @Test
    public void EntityNotDeclaredRespectsIndentSettings2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE article [\r\n\t<!ELEMENT article (#PCDATA)>\r\n]>\r\n<article>\r\n\t&nbsp;\r\n</article>";
        SharedSettings settings = new SharedSettings();
        settings.getPreferences().setQuoteStyle(QuoteStyle.singleQuotes);
        settings.getFormattingSettings().setEnforceQuoteStyle(EnforceQuoteStyle.preferred);
        settings.getFormattingSettings().setInsertSpaces(true);
        settings.getFormattingSettings().setTabSize(3);
        Diagnostic d = XMLAssert.d(5, 1, 5, 7, (IXMLErrorCode)DTDErrorCode.EntityNotDeclared, "The entity \"nbsp\" was referenced, but not declared.");
        XMLAssert.testDiagnosticsFor(xml, d);
        XMLAssert.testCodeActionsFor(xml, d, settings, XMLAssert.ca(d, XMLAssert.te(2, 29, 2, 29, "\r\n   <!ENTITY nbsp 'entity-value'>")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void defaultEntityExpansionLimit() {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationRootSettings validationSettings = new XMLValidationRootSettings();
        validationSettings.setResolveExternalEntities(true);
        settings.setValidation(validationSettings);
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ENGLISH);
            String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE lolz [\r\n    <!ENTITY lol \"lol\">\r\n    <!ELEMENT lolz (#PCDATA)>\r\n    <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\r\n    <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\r\n    <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\r\n    <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\r\n    <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\r\n    <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\r\n    <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\r\n    <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\r\n    <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\r\n]>\r\n<lolz>&lol9;</lolz>";
            Diagnostic diagnostic = XMLAssert.d(14, 6, 14, 12, (IXMLErrorCode)DTDErrorCode.EntityExpansionLimitExceeded, "The parser has encountered more than \"64,000\" entity expansions in this document; this is the limit imposed by the application.", "xml", DiagnosticSeverity.Error);
            XMLAssert.testDiagnosticsFor(new XMLLanguageService(), xml, null, null, null, false, settings, diagnostic);
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customEntityExpansionLimit() {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setUseCache(Boolean.valueOf(true));
        XMLValidationRootSettings validationSettings = new XMLValidationRootSettings();
        validationSettings.setResolveExternalEntities(true);
        settings.setValidation(validationSettings);
        try {
            System.setProperty("jdk.xml.entityExpansionLimit", "10");
            String xml = "<?xml version=\"1.0\"?>\r\n<!DOCTYPE lolz [\r\n    <!ENTITY lol \"lol\">\r\n    <!ELEMENT lolz (#PCDATA)>\r\n    <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\r\n    <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\r\n    <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\r\n    <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\r\n    <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\r\n    <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\r\n    <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\r\n    <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\r\n    <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">\r\n]>\r\n<lolz>&lol9;</lolz>";
            Diagnostic diagnostic = XMLAssert.d(14, 6, 14, 12, (IXMLErrorCode)DTDErrorCode.EntityExpansionLimitExceeded, "The parser has encountered more than \"10\" entity expansions in this document; this is the limit imposed by the application.", "xml", DiagnosticSeverity.Error);
            XMLAssert.testDiagnosticsFor(new XMLLanguageService(), xml, null, null, null, false, settings, diagnostic);
        }
        finally {
            System.setProperty("jdk.xml.entityExpansionLimit", "");
        }
    }
}

