/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb;

import com.ibm.jusb.UsbConfigurationDescriptorImp;
import com.ibm.jusb.UsbConfigurationImp;
import com.ibm.jusb.UsbControlIrpImp;
import com.ibm.jusb.UsbDeviceDescriptorImp;
import com.ibm.jusb.UsbHubImp;
import com.ibm.jusb.UsbInterfaceDescriptorImp;
import com.ibm.jusb.UsbInterfaceImp;
import com.ibm.jusb.UsbPortImp;
import com.ibm.jusb.os.DefaultUsbDeviceOsImp;
import com.ibm.jusb.os.DefaultUsbInterfaceOsImp;
import com.ibm.jusb.os.UsbDeviceOsImp;
import com.ibm.jusb.os.UsbInterfaceOsImp;
import javax.usb.UsbConst;
import javax.usb.UsbException;
import javax.usb.UsbHub;

public class VirtualRootUsbHubImp
extends UsbHubImp
implements UsbHub {
    public static final byte MANUFACTURER_INDEX = 1;
    public static final byte PRODUCT_INDEX = 2;
    public static final byte SERIALNUMBER_INDEX = 3;
    public static final String MANUFACTURER_STRING = "javax.usb OS-independent Reference Implementation";
    public static final String PRODUCT_STRING = "Virtual Root UsbHub";
    public static final String SERIALNUMBER_STRING = "19741113";
    public static final String ENCODING = "UTF-16LE";
    public static final String VIRTUAL_ROOT_USBHUB_SUBMIT_STRING = "Only limited standard requests are possible on the virtual root UsbHub default control pipe.";
    public static final short VENDOR_ID = -1;
    public static final short PRODUCT_ID = -1;
    public static final short DEVICE_BCD = 0;
    public static final short USB_BCD = 257;
    public static final byte CONFIG_NUM = 1;
    public static final short CONFIG_TOTAL_LEN = 18;
    public static final byte INTERFACE_NUM = 0;
    public static final byte SETTING_NUM = 0;
    public static final byte[] stringLangId = new byte[]{4, 3, 0, 0};
    public static final byte[] deviceDescriptorBytes = new byte[]{18, 1, 1, 1, 9, 0, 0, 8, -1, -1, 0, 0, 0, 0, 1};
    public static final UsbDeviceDescriptorImp virtualDeviceDescriptor = new UsbDeviceDescriptorImp(18, 1, 257, 9, 0, 0, 8, -1, -1, 0, 1, 2, 3, 1);
    public static final byte[] configurationDescriptorBytes = new byte[]{9, 2, 18, 0, 1, 1, 0, -128, 0, 9, 4, 0, 0, 0, 9, 0, 0, 0};
    public static final UsbConfigurationDescriptorImp virtualConfigurationDescriptor = new UsbConfigurationDescriptorImp(9, 2, 18, 1, 1, 0, -128, 0);
    public static final UsbInterfaceDescriptorImp virtualInterfaceDescriptor = new UsbInterfaceDescriptorImp(9, 4, 0, 0, 0, 9, 0, 0, 0);

    public VirtualRootUsbHubImp() {
        super(virtualDeviceDescriptor, (UsbDeviceOsImp)new VirtualRootUsbDeviceOsImp());
        this.setSpeed(UsbConst.DEVICE_SPEED_FULL);
        UsbConfigurationImp virtualConfiguration = new UsbConfigurationImp(this, virtualConfigurationDescriptor);
        UsbInterfaceImp virtualInterface = new UsbInterfaceImp(virtualConfiguration, virtualInterfaceDescriptor, new VirtualRootUsbInterfaceOsImp());
        this.setActiveUsbConfigurationNumber((byte)1);
    }

    @Override
    public void connect(UsbHubImp hub, byte portNumber) throws UsbException {
        throw new UsbException("Cannot connect the virtual root UsbHub");
    }

    @Override
    public boolean isRootUsbHub() {
        return true;
    }

    @Override
    public void disconnect() {
        throw new RuntimeException("Cannot disconnect the virtual root UsbHub.");
    }

    @Override
    public void setParentUsbPortImp(UsbPortImp port) {
        throw new RuntimeException("The virtual root UsbHub cannot have any parent UsbPort.");
    }

    @Override
    public UsbPortImp getParentUsbPortImp() {
        return null;
    }

    private static class VirtualRootUsbDeviceOsImp
    extends DefaultUsbDeviceOsImp
    implements UsbDeviceOsImp {
        public VirtualRootUsbDeviceOsImp() {
            super(VirtualRootUsbHubImp.VIRTUAL_ROOT_USBHUB_SUBMIT_STRING);
        }

        @Override
        public void asyncSubmit(UsbControlIrpImp irp) throws UsbException {
            block19: {
                try {
                    if (-128 != (0xFFFFFF80 & irp.bmRequestType())) {
                        throw new UsbException(this.getSubmitString());
                    }
                    if (0 != (0x60 & irp.bmRequestType())) {
                        throw new UsbException(this.getSubmitString());
                    }
                    if (0 == (0x1F & irp.bmRequestType())) {
                        if (8 == irp.bRequest()) {
                            if (0 == irp.wValue() && 0 == irp.wIndex() && 1 == irp.getLength()) {
                                irp.getData()[irp.getOffset()] = 1;
                                irp.setActualLength(1);
                                break block19;
                            }
                            throw new UsbException(this.getSubmitString());
                        }
                        if (6 == irp.bRequest()) {
                            if (1 == (byte)(irp.wValue() >> 8)) {
                                if (0 == (byte)irp.wValue() && 0 == irp.wIndex()) {
                                    irp.setActualLength(irp.getLength() < deviceDescriptorBytes.length ? irp.getLength() : deviceDescriptorBytes.length);
                                    System.arraycopy(deviceDescriptorBytes, 0, irp.getData(), irp.getOffset(), irp.getActualLength());
                                    break block19;
                                }
                                throw new UsbException(this.getSubmitString());
                            }
                            if (2 == irp.wValue() >> 8) {
                                if (1 == (byte)irp.wValue() && 0 == irp.wIndex()) {
                                    irp.setActualLength(irp.getLength() < configurationDescriptorBytes.length ? irp.getLength() : configurationDescriptorBytes.length);
                                    System.arraycopy(configurationDescriptorBytes, 0, irp.getData(), irp.getOffset(), irp.getActualLength());
                                    break block19;
                                }
                                throw new UsbException(this.getSubmitString());
                            }
                            if (3 == irp.wValue() >> 8) {
                                this.getStringDescriptor(irp);
                                break block19;
                            }
                            throw new UsbException(this.getSubmitString());
                        }
                        throw new UsbException(this.getSubmitString());
                    }
                    if (1 == (0x1F & irp.bmRequestType())) {
                        if (10 == irp.bRequest()) {
                            if (0 == irp.wValue() && 0 == irp.wIndex() && 1 == irp.getLength()) {
                                irp.getData()[irp.getOffset()] = 0;
                                irp.setActualLength(1);
                                break block19;
                            }
                            throw new UsbException(this.getSubmitString());
                        }
                        throw new UsbException(this.getSubmitString());
                    }
                    throw new UsbException(this.getSubmitString());
                }
                catch (UsbException uE) {
                    irp.setUsbException(uE);
                    throw uE;
                }
                finally {
                    irp.complete();
                }
            }
        }

        protected void getStringDescriptor(UsbControlIrpImp irp) throws UsbException {
            byte[] str = new byte[]{};
            switch ((byte)irp.wValue()) {
                case 0: {
                    irp.setActualLength(irp.getLength() < stringLangId.length ? irp.getLength() : stringLangId.length);
                    System.arraycopy(stringLangId, 0, irp.getData(), irp.getOffset(), irp.getActualLength());
                    return;
                }
                case 1: {
                    try {
                        str = VirtualRootUsbHubImp.MANUFACTURER_STRING.getBytes(VirtualRootUsbHubImp.ENCODING);
                        break;
                    }
                    catch (Exception e) {
                        irp.setActualLength(0);
                        return;
                    }
                }
                case 2: {
                    try {
                        str = VirtualRootUsbHubImp.PRODUCT_STRING.getBytes(VirtualRootUsbHubImp.ENCODING);
                        break;
                    }
                    catch (Exception e) {
                        irp.setActualLength(0);
                        return;
                    }
                }
                case 3: {
                    try {
                        str = VirtualRootUsbHubImp.SERIALNUMBER_STRING.getBytes(VirtualRootUsbHubImp.ENCODING);
                        break;
                    }
                    catch (Exception e) {
                        irp.setActualLength(0);
                        return;
                    }
                }
                default: {
                    irp.setActualLength(0);
                    return;
                }
            }
            irp.setActualLength(irp.getLength() < 2 + str.length ? irp.getLength() : 2 + str.length);
            irp.getData()[irp.getOffset()] = (byte)irp.getActualLength();
            irp.getData()[1 + irp.getOffset()] = 3;
            System.arraycopy(str, 0, irp.getData(), 2 + irp.getOffset(), irp.getActualLength() - 2);
        }
    }

    private static class VirtualRootUsbInterfaceOsImp
    extends DefaultUsbInterfaceOsImp
    implements UsbInterfaceOsImp {
        private VirtualRootUsbInterfaceOsImp() {
        }

        @Override
        public void claim() throws UsbException {
            throw new UsbException("Cannot claim an interface on a virtual root hub.");
        }

        @Override
        public boolean isClaimed() {
            return true;
        }
    }
}

