/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.Root;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;

public class Client1
extends Util {
    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void joinStringIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.join("doesnotexist");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        this.logMsg("String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.join("doesnotexist", JoinType.INNER);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinStringIllegalArgumentExceptionTest failed");
        }
    }

    public void joinCollectionIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinCollection("doesnotexist");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        this.logMsg("String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinCollection("doesnotexist", JoinType.INNER);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinCollectionIllegalArgumentExceptionTest failed");
        }
    }

    public void joinSetIllegalArgumentExceptionTest() throws Exception {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinSet("doesnotexist");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        this.logMsg("String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinSet("doesnotexist", JoinType.INNER);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinSetIllegalArgumentExceptionTest failed");
        }
    }

    public void joinListIllegalArgumentExceptionTest() throws Exception {
        Root root;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinList("doesnotexist");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        this.logMsg("Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinList("doesnotexist", JoinType.INNER);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinListIllegalArgumentExceptionTest failed");
        }
    }

    public void joinMapIllegalArgumentExceptionTest() throws Exception {
        Root root;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinMap("doesnotexist");
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        this.logMsg("Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinMap("doesnotexist", JoinType.INNER);
                this.logErr("Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("joinMapIllegalArgumentExceptionTest failed");
        }
    }

    public void rootGetCorrelationParentIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            boolean isCorr = customer.isCorrelated();
            if (!isCorr) {
                this.logTrace("isCorrelated() return false");
                pass1 = true;
            } else {
                this.logErr("Expected isCorrelated() to return false, actual:" + isCorr);
            }
            try {
                customer.getCorrelationParent();
                this.logErr("Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                this.logTrace("Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exception", e);
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("rootGetCorrelationParentIllegalStateExceptionTest failed");
        }
    }
}

