/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.annotations.mdcomplete;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.lib.harness.SetupException;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.vehicle.none.proxy.ServletNoVehicle;
import com.sun.ts.tests.connector.annotations.mdcomplete.Client;
import com.sun.ts.tests.connector.annotations.mdcomplete.proxy.ClientServletTarget;
import com.sun.ts.tests.connector.annotations.mdcomplete.proxy.IClient;
import com.sun.ts.tests.connector.annotations.mdcomplete.proxy.IClientProxy;
import com.sun.ts.tests.connector.util.DBSupport;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="connector"), @Tag(value="platform"), @Tag(value="connector_standalone"), @Tag(value="connector_web"), @Tag(value="web_optional"), @Tag(value="tck-javatest")})
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class ClientEjbTest
extends Client {
    static final String VEHICLE_ARCHIVE = "mdcomplete_ejb_vehicle";
    static IClient client;

    @TargetsContainer(value="tck-javatest")
    @OverProtocol(value="javatest")
    @Deployment(name="mdcomplete_ejb_vehicle", order=2)
    public static WebArchive createDeploymentVehicle(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        WebArchive appclientproxy = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"appclientproxy.war");
        appclientproxy.addClasses(new Class[]{Client.class, Fault.class, DBSupport.class, EETest.class, ServiceEETest.class, SetupException.class, ClientServletTarget.class, ServletNoVehicle.class});
        appclientproxy.addAsWebInfResource((Asset)new StringAsset(""), "beans.xml");
        URL webResURL = Client.class.getResource("proxy_servlet_web.xml");
        appclientproxy.addAsWebInfResource(webResURL, "web.xml");
        archiveProcessor.processWebArchive(appclientproxy, Client.class, null);
        return appclientproxy;
    }

    @BeforeAll
    public static void setUp() throws Exception {
        IClientProxy clientProxy = new IClientProxy();
        Properties testProps = System.getProperties();
        String webServerHost = testProps.getProperty("webServerHost", "localhost");
        String webServerPort = testProps.getProperty("webServerPort", "8080");
        client = (IClient)clientProxy.newProxy(webServerHost, webServerPort);
        RemoteStatus status = client.setup(new String[]{VEHICLE_ARCHIVE}, testProps);
        ClientEjbTest.validateStatus(status, "setup");
    }

    @Override
    @Test
    @RunAsClient
    public void testMDCompleteConfigProp() throws Exception {
        RemoteStatus status = client.testMDCompleteConfigProp();
        System.out.println(status);
        ClientEjbTest.validateStatus(status, "testMDCompleteConfigProp");
    }

    @Override
    @Test
    @RunAsClient
    public void testMDCompleteMCFAnno() throws Exception {
        RemoteStatus status = client.testMDCompleteMCFAnno();
        System.out.println(status);
        ClientEjbTest.validateStatus(status, "testMDCompleteMCFAnno");
    }

    static void validateStatus(RemoteStatus status, String test) throws Exception {
        if (status.toStatus().isFailed()) {
            if (status.hasError()) {
                Exception ex = new Exception(test + " failed: " + status.getErrorMessage());
                if (status.getErrorTrace() != null) {
                    ex.setStackTrace(status.getErrorTrace());
                }
                throw ex;
            }
            Assertions.fail((String)(test + " failed: " + status.toString()));
        }
    }
}

