/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.callStmt.callStmt3;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.Utils;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class callStmtClient3
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.callStmt.callStmt3";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private csSchema csSch = null;
    private rsSchema rsSch = null;
    private JDBCTestMsg msg = null;
    private String drManager = null;
    private Properties sqlp = null;
    private transient DatabaseMetaData dbmd = null;
    private CallableStatement cstmt = null;
    private Properties props = null;

    public static void main(String[] args) {
        callStmtClient3 theTests = new callStmtClient3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject01() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 2, 15);
            this.cstmt.registerOutParameter(2, 2, 15);
            this.cstmt.registerOutParameter(3, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            BigDecimal oRetVal = (BigDecimal)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Numeric_Tab");
            BigDecimal oExtVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getObject returns the Maximum value for type BigDecimal ");
            } else {
                this.msg.printTestError("getObject did not return the Maximum value for type BigDecimal", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject02() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 2, 15);
            this.cstmt.registerOutParameter(2, 2, 15);
            this.cstmt.registerOutParameter(3, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            BigDecimal oRetVal = (BigDecimal)this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Numeric_Tab");
            BigDecimal oExtVal = new BigDecimal(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.compareTo(oExtVal) == 0) {
                this.msg.setMsg("getObject returns the Minimum value for type BigDecimal " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Minimum value of type BigDecimal", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject03() throws Exception {
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Numeric_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 2, 15);
            this.cstmt.registerOutParameter(2, 2, 15);
            this.cstmt.registerOutParameter(3, 2, 15);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            BigDecimal oRetVal = (BigDecimal)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null value for type BigDecimal " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Null value for type BigDecimal", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject04() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 6);
            this.cstmt.registerOutParameter(2, 6);
            this.cstmt.registerOutParameter(3, 6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            String sRetStr = this.rsSch.extractVal("Float_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Float_Tab");
            this.msg.setMsg("Calling CallableStatement.getObject(Double.MaximumValue(JDBC FLOAT))");
            try {
                this.msg.setMsg("invoke getObject method");
                Float oRetVal = (Float)this.cstmt.getObject(1);
                this.msg.setMsg("It is a Float");
                Float oExtVal = Float.valueOf(sRetStr);
                this.msg.setMsg("Value retrieved using cstmt\t  :" + oRetVal);
                this.msg.setMsg("Value extracted from ctsql.stmt   :" + oExtVal);
                this.msg.addOutputMsg(sRetStr, oRetVal.toString());
                if (Utils.isMatchingFloatingPointVal(oExtVal, oRetVal)) {
                    this.msg.setMsg("getObject returns the Maximum value for type Double(JDBC FLOAT) " + oRetVal);
                } else {
                    this.msg.printTestError("getObject did not return the Maximum value for type Double(JDBC FLOAT)", "Call to getObject Failed!");
                }
            }
            catch (ClassCastException ce) {
                this.msg.setMsg("Assuming it is a Double");
                Double oRetVal = (Double)this.cstmt.getObject(1);
                Double oExtVal = new Double(sRetStr);
                this.msg.setMsg("Value retrieved using cstmt\t  :" + oRetVal);
                this.msg.setMsg("Value extracted from ctsql.stmt   :" + oExtVal);
                this.msg.addOutputMsg(sRetStr, oRetVal.toString());
                if (Utils.isMatchingFloatingPointVal(oExtVal, oRetVal)) {
                    this.msg.setMsg("getObject returns the Maximum value for type Double(JDBC FLOAT) " + oRetVal);
                }
                this.msg.printTestError("getObject did not return the Maximum value for type Double(JDBC FLOAT)", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject05() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 6);
            this.cstmt.registerOutParameter(2, 6);
            this.cstmt.registerOutParameter(3, 6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(Double.MinimumValue(JDBC FLOAT))");
            String sRetStr = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Float_Tab");
            try {
                this.msg.setMsg("invoke getObject method");
                Float oRetVal = (Float)this.cstmt.getObject(2);
                this.msg.setMsg("It is a Float");
                Float oExtVal = Float.valueOf(sRetStr);
                this.msg.setMsg("From ctssql value is " + sRetStr);
                this.msg.setMsg("From cstmt value is " + oRetVal);
                this.msg.addOutputMsg(sRetStr, oRetVal.toString());
                if (Utils.isMatchingFloatingPointVal(oExtVal, oRetVal)) {
                    this.msg.setMsg("getObject returns the Minimum value for type Double(JDBC FLOAT) " + oRetVal);
                } else {
                    this.msg.printTestError("getObject did not return the Minimum value for type Double(JDBC FLOAT)", "Call to getObject Failed!");
                }
            }
            catch (ClassCastException ce) {
                this.msg.setMsg("invoke getObject method");
                Double oRetVal = (Double)this.cstmt.getObject(2);
                this.msg.setMsg("It is a Double");
                Float oExtVal = Float.valueOf(sRetStr);
                this.msg.setMsg("From tssql value is " + sRetStr);
                this.msg.setMsg("value retrieved by getObject method is " + oRetVal);
                this.msg.addOutputMsg(sRetStr, oRetVal.toString());
                if (Utils.isMatchingFloatingPointVal(oExtVal, Float.valueOf(oRetVal.floatValue()))) {
                    this.msg.setMsg("getObject returns the Minimum value for type Double(JDBC FLOAT) " + oRetVal);
                }
                this.msg.printTestError("getObject did not return the Minimum value for type Double(JDBC FLOAT)", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject06() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Float_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 6);
            this.cstmt.registerOutParameter(2, 6);
            this.cstmt.registerOutParameter(3, 6);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Float oRetVal = (Float)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null value for type Double (JDBC FLOAT) " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Null value for type Double(JDBC FLOAT)", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject07() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.cstmt.registerOutParameter(2, 5);
            this.cstmt.registerOutParameter(3, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String sRetVal = "" + this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Smallint_Tab");
            this.msg.addOutputMsg(sRetStr, sRetVal);
            if (sRetVal.trim().equals(sRetStr.trim())) {
                this.msg.setMsg("getObject returns the Maximum value for type Integer(JDBC SMALLINT) " + sRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Maximum value for type Integer(JDBC SMALLINT)", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject08() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.cstmt.registerOutParameter(2, 5);
            this.cstmt.registerOutParameter(3, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String sRetVal = "" + this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Smallint_Tab");
            this.msg.addOutputMsg(sRetStr, sRetVal);
            if (sRetVal.trim().equals(sRetStr.trim())) {
                this.msg.setMsg("getObject returns the Minimum value for type Integer(JDBC SMALLINT) " + sRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Minimum value for type Integer(JDBC SMALLINT)", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject09() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Smallint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 5);
            this.cstmt.registerOutParameter(2, 5);
            this.cstmt.registerOutParameter(3, 5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Integer oRetVal = (Integer)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null value for type Integer(JDBC SMALLINT) " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Null value for type Integer(JDBC SMALLINT)", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject10() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 1);
            this.cstmt.registerOutParameter(2, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(1);
            oRetVal = oRetVal.trim();
            String oExtVal = this.rsSch.extractVal("Char_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted char value from Char_Tab");
            oExtVal = oExtVal.trim();
            this.msg.addOutputMsg(oExtVal, oRetVal);
            if (oRetVal.equals(oExtVal.substring(1, oExtVal.length() - 1))) {
                this.msg.setMsg("getObject returns the Name for type String" + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Name for type String", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject11() throws Exception {
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Char_Proc(?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 1);
            this.cstmt.registerOutParameter(2, 1);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            String oRetVal = (String)this.cstmt.getObject(2);
            this.msg.addOutputMsg("null", oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the null value for type String " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the null value for type String", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject12() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Integer oRetVal = (Integer)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Integer_Tab");
            Integer oExtVal = new Integer(sRetStr);
            this.msg.addOutputMsg(sRetStr, oExtVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Maximum value for type Integer " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Maximum value for type Integer", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject13() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Integer oRetVal = (Integer)this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Integer_Tab");
            Integer oExtVal = new Integer(sRetStr);
            this.msg.addOutputMsg(sRetStr, oExtVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Minimum value for type Integer " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Minimum value for type Integer", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject14() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Integer_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, 4);
            this.cstmt.registerOutParameter(2, 4);
            this.cstmt.registerOutParameter(3, 4);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Integer oRetVal = (Integer)this.cstmt.getObject(3);
            this.msg.addOutputMsg("null", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null value for type Integer " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Null value for type Integer", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject15() throws Exception {
        Boolean oMaxBooleanVal = null;
        boolean booleanVal = false;
        String smaxBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Proc(?,?,?)}");
            smaxBooleanVal = this.rsSch.extractValAsNumericString("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Bit_Tab: " + smaxBooleanVal);
            oMaxBooleanVal = this.rsSch.extractValAsBoolObj("Bit_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.cstmt.registerOutParameter(2, -7);
            this.cstmt.registerOutParameter(3, -7);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            rStringVal = this.cstmt.getObject(1).toString();
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMaxBooleanVal.toString()) || rStringVal.equals(smaxBooleanVal.trim())) {
                this.msg.setMsg("getObject returns the Maximum value for type Boolean " + oMaxBooleanVal);
            } else {
                this.msg.printTestError("getObject did not return the Maximum value for type Boolean", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject16() throws Exception {
        Boolean oMinBooleanVal = null;
        String sminBooleanVal = null;
        String rStringVal = null;
        try {
            this.rsSch.createTab("Bit_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bit_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -7);
            this.cstmt.registerOutParameter(2, -7);
            this.cstmt.registerOutParameter(3, -7);
            sminBooleanVal = this.rsSch.extractVal("Bit_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Bit_Tab");
            if (this.csSch.supportsType("BOOLEAN", this.conn)) {
                if (sminBooleanVal.equals("1")) {
                    sminBooleanVal = "true";
                }
                oMinBooleanVal = new Boolean(sminBooleanVal);
            } else {
                boolean booleanVal = sminBooleanVal.trim().equals("1");
                oMinBooleanVal = new Boolean(booleanVal);
            }
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            rStringVal = this.cstmt.getObject(2).toString();
            rStringVal = rStringVal.trim();
            if (rStringVal.equals(oMinBooleanVal.toString()) || rStringVal.equals(sminBooleanVal.trim())) {
                this.msg.setMsg("getObject returns the Minimum value for type Boolean " + oMinBooleanVal);
            } else {
                this.msg.printTestError("getObject did not return the Minimum value for type Boolean", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bit_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject18() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.cstmt.registerOutParameter(2, -5);
            this.cstmt.registerOutParameter(3, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Long oRetVal = (Long)this.cstmt.getObject(1);
            String sRetStr = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            this.msg.setMsg("extracted maximum value from Bigint_Tab");
            Long oExtVal = new Long(sRetStr);
            this.msg.addOutputMsg(sRetStr, oExtVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Maximum value for type Long " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Maximum value for type Long", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetObject19() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.cstmt.registerOutParameter(2, -5);
            this.cstmt.registerOutParameter(3, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("Calling CallableStatement.getObject(Long.MinimumValue)");
            this.msg.setMsg("invoke getObject method");
            Long oRetVal = (Long)this.cstmt.getObject(2);
            String sRetStr = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            this.msg.setMsg("extracted minimum value from Bigint_Tab");
            Long oExtVal = new Long(sRetStr);
            this.msg.addOutputMsg(sRetStr, oRetVal.toString());
            if (oRetVal.equals(oExtVal)) {
                this.msg.setMsg("getObject returns the Minimum value for type Long " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Minimum value for type Long", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetObject20() throws Exception {
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("get the CallableStatement object");
            this.cstmt = this.conn.prepareCall("{call Bigint_Proc(?,?,?)}");
            this.msg.setMsg("register the output parameters");
            this.cstmt.registerOutParameter(1, -5);
            this.cstmt.registerOutParameter(2, -5);
            this.cstmt.registerOutParameter(3, -5);
            this.msg.setMsg("execute the procedure");
            this.cstmt.executeUpdate();
            this.msg.setMsg("invoke getObject method");
            Long oRetVal = (Long)this.cstmt.getObject(3);
            this.msg.addOutputMsg("0", "" + oRetVal);
            if (oRetVal == null) {
                this.msg.setMsg("getObject returns the Null value for type Long " + oRetVal);
            } else {
                this.msg.printTestError("getObject did not return the Null value for type Long", "Call to getObject Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getObject Failed!");
        }
        finally {
            try {
                if (this.cstmt != null) {
                    this.cstmt.close();
                    this.cstmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

