/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.batik.ext.awt.geom.Segment;

public abstract class AbstractSegment
implements Segment {
    private static final double rt3 = 1.7320508075689;
    static final double eps = 3.552713678800501E-15;
    static final double tol = 1.4210854715202004E-14;

    protected abstract int findRoots(double var1, double[] var3);

    public Segment.SplitResults split(double d) {
        Segment[] segmentArray;
        Segment[] segmentArray2;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        int n = this.findRoots(d, dArray);
        if (n == 0) {
            return null;
        }
        Arrays.sort(dArray, 0, n);
        double[] dArray2 = new double[n + 2];
        int n2 = 0;
        dArray2[n2++] = 0.0;
        int n3 = 0;
        while (n3 < n) {
            double d2 = dArray[n3];
            if (!(d2 <= 0.0)) {
                if (d2 >= 1.0) break;
                if (dArray2[n2 - 1] != d2) {
                    dArray2[n2++] = d2;
                }
            }
            ++n3;
        }
        dArray2[n2++] = 1.0;
        if (n2 == 2) {
            return null;
        }
        Segment[] segmentArray3 = new Segment[n2];
        double d3 = 0.0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = 1;
        while (n5 < n2) {
            segmentArray3[n4] = this.getSegment(dArray2[n5 - 1], dArray2[n5]);
            segmentArray2 = segmentArray3[n4].eval(0.5);
            if (n4 == 0) {
                ++n4;
                bl2 = segmentArray2.y < d;
                bl = bl2;
            } else {
                boolean bl3;
                boolean bl4 = bl3 = segmentArray2.y < d;
                if (bl2 == bl3) {
                    segmentArray3[n4 - 1] = this.getSegment(d3, dArray2[n5]);
                } else {
                    ++n4;
                    d3 = dArray2[n5 - 1];
                    bl2 = bl3;
                }
            }
            ++n5;
        }
        if (n4 == 1) {
            return null;
        }
        if (bl) {
            segmentArray = new Segment[(n4 + 1) / 2];
            segmentArray2 = new Segment[n4 / 2];
        } else {
            segmentArray = new Segment[n4 / 2];
            segmentArray2 = new Segment[(n4 + 1) / 2];
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            if (bl) {
                segmentArray[n6++] = segmentArray3[n8];
            } else {
                segmentArray2[n7++] = segmentArray3[n8];
            }
            bl = !bl;
            ++n8;
        }
        return new Segment.SplitResults(segmentArray2, segmentArray);
    }

    public Segment splitBefore(double d) {
        return this.getSegment(0.0, d);
    }

    public Segment splitAfter(double d) {
        return this.getSegment(d, 1.0);
    }

    public static int solveLine(double d, double d2, double[] dArray) {
        if (d == 0.0) {
            if (d2 != 0.0) {
                return 0;
            }
            dArray[0] = 0.0;
            return 1;
        }
        dArray[0] = -d2 / d;
        return 1;
    }

    public static int solveQuad(double d, double d2, double d3, double[] dArray) {
        if (d == 0.0) {
            return AbstractSegment.solveLine(d2, d3, dArray);
        }
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (Math.abs(d4) <= 1.4210854715202004E-14 * d2 * d2) {
            dArray[0] = -d2 / (2.0 * d);
            return 1;
        }
        if (d4 < 0.0) {
            return 0;
        }
        d4 = Math.sqrt(d4);
        double d5 = -(d2 + AbstractSegment.matchSign(d4, d2));
        dArray[0] = 2.0 * d3 / d5;
        dArray[1] = d5 / (2.0 * d);
        return 2;
    }

    public static double matchSign(double d, double d2) {
        if (d2 < 0.0) {
            return d < 0.0 ? d : -d;
        }
        return d > 0.0 ? d : -d;
    }

    public static int solveCubic(double d, double d2, double d3, double d4, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        int n = AbstractSegment.solveQuad(3.0 * d, 2.0 * d2, d3, dArray2);
        double[] dArray3 = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray4 = new double[]{0.0, 0.0, 0.0, 0.0};
        int n2 = 0;
        dArray3[n2] = d4;
        dArray4[n2++] = 0.0;
        switch (n) {
            case 1: {
                double d5 = dArray2[0];
                if (!(d5 > 0.0) || !(d5 < 1.0)) break;
                dArray3[n2] = ((d * d5 + d2) * d5 + d3) * d5 + d4;
                dArray4[n2++] = d5;
                break;
            }
            case 2: {
                double d5;
                if (dArray2[0] > dArray2[1]) {
                    double d6 = dArray2[0];
                    dArray2[0] = dArray2[1];
                    dArray2[1] = d6;
                }
                if ((d5 = dArray2[0]) > 0.0 && d5 < 1.0) {
                    dArray3[n2] = ((d * d5 + d2) * d5 + d3) * d5 + d4;
                    dArray4[n2++] = d5;
                }
                if (!((d5 = dArray2[1]) > 0.0) || !(d5 < 1.0)) break;
                dArray3[n2] = ((d * d5 + d2) * d5 + d3) * d5 + d4;
                dArray4[n2++] = d5;
                break;
            }
        }
        dArray3[n2] = d + d2 + d3 + d4;
        dArray4[n2++] = 1.0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2 - 1) {
            double d7 = dArray3[n4];
            double d8 = dArray4[n4];
            double d9 = dArray3[n4 + 1];
            double d10 = dArray4[n4 + 1];
            if (!(d7 < 0.0 && d9 < 0.0 || d7 > 0.0 && d9 > 0.0)) {
                double d11;
                if (d7 > d9) {
                    d11 = d7;
                    d7 = d9;
                    d9 = d11;
                    d11 = d8;
                    d8 = d10;
                    d10 = d11;
                }
                if (-d7 < 1.4210854715202004E-14 * d9) {
                    dArray[n3++] = d8;
                } else if (d9 < -1.4210854715202004E-14 * d7) {
                    dArray[n3++] = d10;
                    ++n4;
                } else {
                    d11 = 1.4210854715202004E-14 * (d9 - d7);
                    int n5 = 0;
                    while (n5 < 20) {
                        double d12 = d10 - d8;
                        double d13 = d9 - d7;
                        double d14 = d8 + (Math.abs(d7 / d13) * 99.0 + 0.5) * d12 / 100.0;
                        double d15 = ((d * d14 + d2) * d14 + d3) * d14 + d4;
                        if (Math.abs(d15) < d11) {
                            dArray[n3++] = d14;
                            break;
                        }
                        if (d15 < 0.0) {
                            d8 = d14;
                            d7 = d15;
                        } else {
                            d10 = d14;
                            d9 = d15;
                        }
                        ++n5;
                    }
                    if (n5 == 20) {
                        dArray[n3++] = (d8 + d10) / 2.0;
                    }
                }
            }
            ++n4;
        }
        return n3;
    }

    public abstract double getLength(double var1);

    public abstract double getLength();

    public abstract void subdivide(double var1, Segment var3, Segment var4);

    public abstract void subdivide(Segment var1, Segment var2);

    public abstract Segment getSegment(double var1, double var3);

    public abstract Point2D.Double eval(double var1);

    public abstract Point2D.Double evalDt(double var1);

    public abstract Rectangle2D getBounds2D();

    public abstract double maxY();

    public abstract double minY();

    public abstract double maxX();

    public abstract double minX();
}

