/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tomcat.JarScanner;
import org.eclipse.gemini.web.tomcat.spi.JarScannerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class DelegatingJarScannerCustomizer
implements JarScannerCustomizer {
    private final BundleContext context;
    private final ServiceTracker<JarScannerCustomizer, Object> tracker;
    private volatile Set<JarScannerCustomizer> delegate;

    DelegatingJarScannerCustomizer(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, JarScannerCustomizer.class.getName(), (ServiceTrackerCustomizer)new Customizer());
    }

    void open() {
        this.tracker.open();
    }

    void close() {
        this.tracker.close();
    }

    @Override
    public JarScanner[] extendJarScannerChain(Bundle bundle) {
        if (this.delegate != null && this.delegate.size() > 0) {
            HashSet<JarScanner> jarScanners = new HashSet<JarScanner>();
            for (JarScannerCustomizer jarScannerCustomizer : this.delegate) {
                jarScanners.addAll(Arrays.asList(jarScannerCustomizer.extendJarScannerChain(bundle)));
            }
            return jarScanners.toArray(new JarScanner[jarScanners.size()]);
        }
        return new JarScanner[0];
    }

    private class Customizer
    implements ServiceTrackerCustomizer<JarScannerCustomizer, Object> {
        private Customizer() {
        }

        public Object addingService(ServiceReference<JarScannerCustomizer> reference) {
            JarScannerCustomizer newDelegate = (JarScannerCustomizer)DelegatingJarScannerCustomizer.this.context.getService(reference);
            if (DelegatingJarScannerCustomizer.this.delegate == null) {
                DelegatingJarScannerCustomizer.this.delegate = new HashSet();
            }
            DelegatingJarScannerCustomizer.this.delegate.add(newDelegate);
            return newDelegate;
        }

        public void modifiedService(ServiceReference<JarScannerCustomizer> reference, Object service) {
        }

        public void removedService(ServiceReference<JarScannerCustomizer> reference, Object service) {
            if (DelegatingJarScannerCustomizer.this.delegate != null) {
                DelegatingJarScannerCustomizer.this.delegate.remove(DelegatingJarScannerCustomizer.this.context.getService(reference));
            }
            DelegatingJarScannerCustomizer.this.context.ungetService(reference);
        }
    }
}

