/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.util.common.Assert;
import org.eclipse.virgo.util.common.DirectedAcyclicGraph;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.common.ThreadSafeGraphNode;

public class ThreadSafeDirectedAcyclicGraph<V>
implements DirectedAcyclicGraph<V> {
    private final Object monitor = new Object();
    private static final Object tieMonitor = new Object();
    private final List<ThreadSafeGraphNode<V>> nodes = new ArrayList<ThreadSafeGraphNode<V>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadSafeGraphNode<V> createRootNode(V value) {
        Object object = this.monitor;
        synchronized (object) {
            ThreadSafeGraphNode<V> node = new ThreadSafeGraphNode<V>(value, this.monitor);
            this.nodes.add(node);
            return node;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRootNode(GraphNode<V> node) {
        this.assertTypeAndMembership(node);
        Object object = this.monitor;
        synchronized (object) {
            Assert.isTrue(node.getChildren().isEmpty(), "Cannot delete node '%s'. Node has children. Please remove the children first.", node);
            Assert.isTrue(node.getParents().isEmpty(), "Cannot delete node '%s'. Node is still in use. Please remove it from the other node(s) first.", node);
            boolean removed = this.nodes.remove(node);
            return removed;
        }
    }

    private ThreadSafeGraphNode<V> assertTypeAndMembership(GraphNode<V> child) {
        Assert.isInstanceOf(ThreadSafeGraphNode.class, child, "A child must be of type %s.", this.getClass().getName());
        ThreadSafeGraphNode concreteChild = (ThreadSafeGraphNode)child;
        Assert.isTrue(concreteChild.belongsToSameGraph(this.monitor), "The node '%s' does not belong to the graph '%s'", concreteChild, this);
        return concreteChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphNode<V>> getRootNodes() {
        ArrayList<GraphNode<V>> rootNodes = new ArrayList<GraphNode<V>>();
        Object object = this.monitor;
        synchronized (object) {
            for (GraphNode graphNode : this.nodes) {
                if (!graphNode.isRootNode()) continue;
                rootNodes.add(graphNode);
            }
            return rootNodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("<");
        Object object = this.monitor;
        synchronized (object) {
            boolean first = true;
            for (GraphNode<V> child : this.getRootNodes()) {
                if (!first) {
                    result.append(", ");
                }
                result.append(child.toString());
                first = false;
            }
        }
        result.append(">");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.monitor;
        synchronized (object) {
            int result = 1;
            result = 31 * result + this.nodes.hashCode();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        int otherHash;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadSafeDirectedAcyclicGraph other = (ThreadSafeDirectedAcyclicGraph)obj;
        int thisHash = System.identityHashCode(this);
        if (thisHash < (otherHash = System.identityHashCode(other))) {
            Object object = this.monitor;
            synchronized (object) {
                Object object2 = other.monitor;
                synchronized (object2) {
                    if (this.nodes.equals(other.nodes)) return true;
                    return false;
                }
            }
        }
        if (thisHash > otherHash) {
            Object object = other.monitor;
            synchronized (object) {
                Object object3 = this.monitor;
                synchronized (object3) {
                    if (this.nodes.equals(other.nodes)) return true;
                    return false;
                }
            }
        }
        Object object = tieMonitor;
        synchronized (object) {
            Object object4 = this.monitor;
            synchronized (object4) {
                Object object5 = other.monitor;
                synchronized (object5) {
                    if (this.nodes.equals(other.nodes)) return true;
                    return false;
                }
            }
        }
    }
}

