/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.catalina.startup.TldConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.res.StringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJarScanner
implements JarScanner {
    private static final String JAR_EXT = ".jar";
    private static final String WEB_INF_LIB = "/WEB-INF/lib/";
    private static Log log = LogFactory.getLog(TldConfig.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    private boolean scanClassPath = true;
    private boolean scanAllFiles = false;
    private boolean scanAllDirectories = false;

    public boolean isScanClassPath() {
        return this.scanClassPath;
    }

    public void setScanClassPath(boolean scanClassPath) {
        this.scanClassPath = scanClassPath;
    }

    public boolean isScanAllFiles() {
        return this.scanAllFiles;
    }

    public void setScanAllFiles(boolean scanAllFiles) {
        this.scanAllFiles = scanAllFiles;
    }

    public boolean isScanAllDirectories() {
        return this.scanAllDirectories;
    }

    public void setScanAllDirectories(boolean scanAllDirectories) {
        this.scanAllDirectories = scanAllDirectories;
    }

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        Set dirList;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        if ((dirList = context.getResourcePaths(WEB_INF_LIB)) != null) {
            for (String path : dirList) {
                if (!path.endsWith(JAR_EXT) || jarsToSkip.contains(path.substring(path.lastIndexOf(47)))) continue;
                URL url = null;
                try {
                    url = context.getResource(path);
                    this.process(callback, url);
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url}), (Throwable)e);
                }
            }
        }
        if (this.scanClassPath) {
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("jarScan.classloaderStart"));
            }
            for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
                if (!(loader instanceof URLClassLoader)) continue;
                URL[] urls = ((URLClassLoader)loader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    String jarName = this.getJarName(urls[i]);
                    if (jarsToSkip.contains(jarName) || urls[i].toString().contains(WEB_INF_LIB + jarName)) continue;
                    try {
                        this.process(callback, urls[i]);
                        continue;
                    }
                    catch (IOException ioe) {
                        log.warn((Object)sm.getString("jarScan.classloaderFail", new Object[]{urls[i]}), (Throwable)ioe);
                    }
                }
            }
        }
    }

    private void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.jarUrlStart", new Object[]{url}));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:")) {
                if (urlStr.endsWith(JAR_EXT)) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && this.scanAllFiles) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && this.scanAllDirectories && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }

    private String getJarName(URL url) {
        String name = null;
        String path = url.getPath();
        int end = path.indexOf(JAR_EXT);
        if (end != -1) {
            int start = path.lastIndexOf(47, end);
            name = path.substring(start + 1, end + 4);
        }
        return name;
    }
}

