/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework;

import java.io.IOException;
import java.util.ArrayList;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.eclipse.gemini.management.Monitor;
import org.eclipse.gemini.management.framework.CustomServiceStateMBean;
import org.eclipse.gemini.management.framework.internal.OSGiService;
import org.eclipse.gemini.management.framework.internal.OSGiServiceEvent;
import org.eclipse.gemini.management.internal.OSGiProperties;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public final class ServiceState
extends Monitor
implements CustomServiceStateMBean {
    private ServiceListener serviceListener;
    private BundleContext bundleContext;

    public ServiceState(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public long getBundleIdentifier(long serviceId) throws IOException {
        return this.getServiceReference(serviceId).getBundle().getBundleId();
    }

    @Override
    public TabularData getProperties(long serviceId) throws IOException {
        return OSGiProperties.tableFrom(this.getServiceReference(serviceId));
    }

    @Override
    public String[] getObjectClass(long serviceId) throws IOException {
        return (String[])this.getServiceReference(serviceId).getProperty("objectClass");
    }

    @Override
    public TabularData listServices() {
        ArrayList<OSGiService> services = new ArrayList<OSGiService>();
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            ServiceReference[] refs = bundle.getRegisteredServices();
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n3 = refs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServiceReference ref = serviceReferenceArray[n4];
                    services.add(new OSGiService(ref));
                    ++n4;
                }
            }
            ++n2;
        }
        return OSGiService.tableFrom(services);
    }

    @Override
    public long[] getUsingBundles(long serviceId) throws IOException {
        return OSGiService.getBundlesUsing(this.getServiceReference(serviceId));
    }

    @Override
    public CompositeData getService(long serviceId) throws IOException {
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            ServiceReference[] refs = bundle.getRegisteredServices();
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n3 = refs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServiceReference ref = serviceReferenceArray[n4];
                    if (serviceId == (Long)ref.getProperty("service.id")) {
                        return new OSGiService(ref).asCompositeData();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public CompositeData getProperty(long serviceId, String key) throws IOException {
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            ServiceReference[] refs = bundle.getRegisteredServices();
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n3 = refs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ServiceReference ref = serviceReferenceArray[n4];
                    if (serviceId == (Long)ref.getProperty("service.id")) {
                        return OSGiProperties.encode(key, ref.getProperty(key));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public TabularData listServices(String clazz, String filter) throws IOException {
        try {
            ServiceReference[] allServiceReferences;
            ArrayList<OSGiService> services = new ArrayList<OSGiService>();
            ServiceReference[] serviceReferenceArray = allServiceReferences = this.bundleContext.getAllServiceReferences(clazz, filter);
            int n = allServiceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference reference = serviceReferenceArray[n2];
                services.add(new OSGiService(reference));
                ++n2;
            }
            return OSGiService.tableFrom(services);
        }
        catch (InvalidSyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TabularData listServices(String clazz, String filter, String ... serviceTypeItems) throws IOException {
        try {
            ServiceReference[] allServiceReferences;
            ArrayList<OSGiService> services = new ArrayList<OSGiService>();
            ServiceReference[] serviceReferenceArray = allServiceReferences = this.bundleContext.getAllServiceReferences(clazz, filter);
            int n = allServiceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference reference = serviceReferenceArray[n2];
                services.add(new OSGiService(reference));
                ++n2;
            }
            TabularData table = OSGiService.tableFrom(services, serviceTypeItems);
            return table;
        }
        catch (InvalidSyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long[] getServiceIds() throws IOException {
        try {
            ServiceReference[] allServiceReferences = this.bundleContext.getAllServiceReferences(null, null);
            long[] serviceIds = new long[allServiceReferences.length];
            int i = 0;
            while (i < allServiceReferences.length) {
                serviceIds[i] = (Long)allServiceReferences[i].getProperty("service.id");
                ++i;
            }
            return serviceIds;
        }
        catch (InvalidSyntaxException e) {
            throw new IOException(e);
        }
    }

    @Override
    public CompositeData[] getRegisteredServices(long bundleId) throws IOException {
        Bundle bundle = this.getBundle(bundleId);
        ServiceReference[] registeredServices = bundle.getRegisteredServices();
        return this.getServicesAsCompositeDatas(registeredServices);
    }

    @Override
    public CompositeData[] getServicesInUse(long bundleId) throws IOException {
        Bundle bundle = this.getBundle(bundleId);
        ServiceReference[] servicesInUse = bundle.getServicesInUse();
        return this.getServicesAsCompositeDatas(servicesInUse);
    }

    private Bundle getBundle(long bundleId) {
        Bundle bundle = this.bundleContext.getBundle(bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("No such bundle '" + bundleId + "'");
        }
        return bundle;
    }

    private CompositeData[] getServicesAsCompositeDatas(ServiceReference<?>[] services) {
        CompositeData[] servicesInUseCompositeData;
        if (services != null) {
            servicesInUseCompositeData = new CompositeData[services.length];
            int i = 0;
            while (i < services.length) {
                servicesInUseCompositeData[i] = new OSGiService(services[i]).asCompositeData();
                ++i;
            }
        } else {
            servicesInUseCompositeData = new CompositeData[]{};
        }
        return servicesInUseCompositeData;
    }

    private ServiceReference<?> getServiceReference(long serviceId) throws IOException {
        Filter filter;
        try {
            filter = this.bundleContext.createFilter("(service.id=" + serviceId + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new IOException("Invalid filter syntax: " + (Object)((Object)e));
        }
        ServiceTracker tracker = new ServiceTracker(this.bundleContext, filter, null);
        tracker.open();
        ServiceReference serviceReference = tracker.getServiceReference();
        if (serviceReference == null) {
            throw new IOException("Service <" + serviceId + "> does not exist");
        }
        tracker.close();
        return serviceReference;
    }

    @Override
    protected void addListener() {
        this.serviceListener = this.getServiceListener();
        this.bundleContext.addServiceListener(this.serviceListener);
    }

    @Override
    protected void removeListener() {
        if (this.serviceListener != null) {
            this.bundleContext.removeServiceListener(this.serviceListener);
        }
    }

    private ServiceListener getServiceListener() {
        return new AllServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                ObjectName objectName = ServiceState.this.objectName;
                ServiceState serviceState = ServiceState.this;
                long l = serviceState.sequenceNumber;
                serviceState.sequenceNumber = l + 1L;
                Notification notification = new Notification("ServiceEvent", objectName, l);
                notification.setUserData(new OSGiServiceEvent(serviceEvent).asCompositeData());
                ServiceState.this.sendNotification(notification);
            }
        };
    }
}

