/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.management.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.management.openmbean.CompositeData;
import org.eclipse.gemini.management.framework.internal.BundleBatchActionResult;
import org.eclipse.gemini.management.framework.internal.BundleBatchInstallResult;
import org.eclipse.gemini.management.framework.internal.BundleBatchResolveResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.jmx.framework.FrameworkMBean;

public final class Framework
implements FrameworkMBean {
    private BundleContext bundleContext;
    private FrameworkStartLevel frameworkStartLevel;
    private FrameworkWiring frameworkWiring;

    public Framework(BundleContext bc) {
        this.bundleContext = bc;
        this.frameworkStartLevel = (FrameworkStartLevel)bc.getBundle(0L).adapt(FrameworkStartLevel.class);
        this.frameworkWiring = (FrameworkWiring)bc.getBundle(0L).adapt(FrameworkWiring.class);
    }

    @Override
    public int getFrameworkStartLevel() throws IOException {
        return this.frameworkStartLevel.getStartLevel();
    }

    @Override
    public int getInitialBundleStartLevel() throws IOException {
        return this.frameworkStartLevel.getInitialBundleStartLevel();
    }

    @Override
    public long installBundle(String location) throws IOException {
        try {
            return this.bundleContext.installBundle(location).getBundleId();
        }
        catch (Throwable e) {
            throw new IOException("Unable to install bundle: " + e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long installBundleFromURL(String location, String url) throws IOException {
        long l;
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            l = this.bundleContext.installBundle(location, is).getBundleId();
            if (is == null) return l;
        }
        catch (Throwable e) {
            try {
                throw new IOException("Unable to install bundle: " + e);
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            is.close();
            return l;
        }
        catch (IOException iOException) {}
        return l;
    }

    @Override
    public CompositeData installBundles(String[] locations) throws IOException {
        if (locations == null) {
            throw new IOException("locations must not be null");
        }
        Long[] ids = new Long[locations.length];
        int i = 0;
        while (i < locations.length) {
            try {
                ids[i] = this.bundleContext.installBundle(locations[i]).getBundleId();
            }
            catch (Throwable e) {
                Long[] completed = new Long[i];
                System.arraycopy(ids, 0, completed, 0, completed.length);
                String[] remaining = new String[locations.length - i - 1];
                System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                return new BundleBatchInstallResult(e.toString(), completed, locations[i], remaining).asCompositeData();
            }
            ++i;
        }
        return new BundleBatchInstallResult(ids).asCompositeData();
    }

    @Override
    public CompositeData installBundlesFromURL(String[] locations, String[] urls) throws IOException {
        if (locations == null) {
            throw new IOException("locations must not be null");
        }
        if (urls == null) {
            throw new IOException("urls must not be null");
        }
        Long[] ids = new Long[locations.length];
        int i = 0;
        while (i < locations.length) {
            InputStream is = null;
            try {
                try {
                    is = new URL(urls[i]).openStream();
                    ids[i] = this.bundleContext.installBundle(locations[i], is).getBundleId();
                }
                catch (Throwable e) {
                    Long[] completed = new Long[i];
                    System.arraycopy(ids, 0, completed, 0, completed.length);
                    String[] remaining = new String[locations.length - i - 1];
                    System.arraycopy(locations, i + 1, remaining, 0, remaining.length);
                    CompositeData compositeData = new BundleBatchInstallResult(e.toString(), completed, locations[i], remaining).asCompositeData();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return compositeData;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return new BundleBatchInstallResult(ids).asCompositeData();
    }

    @Override
    public void refreshBundle(long bundleIdentifier) throws IOException {
        List<Bundle> bundles = Arrays.asList(this.bundle(bundleIdentifier));
        this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[0]);
    }

    @Override
    public void refreshBundles(long[] bundleIdentifiers) throws IOException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (bundleIdentifiers != null) {
            int i = 0;
            while (i < bundleIdentifiers.length) {
                try {
                    bundles.add(this.bundle(bundleIdentifiers[i]));
                }
                catch (Throwable e) {
                    IOException iox = new IOException("Unable to refresh packages");
                    iox.initCause(e);
                    throw iox;
                }
                ++i;
            }
        }
        try {
            this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[0]);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Unable to refresh packages");
            iox.initCause(e);
            throw iox;
        }
    }

    @Override
    public boolean resolveBundle(long bundleIdentifier) throws IOException {
        List<Bundle> bundles = Arrays.asList(this.bundle(bundleIdentifier));
        return this.frameworkWiring.resolveBundles(bundles);
    }

    @Override
    public boolean resolveBundles(long[] bundleIdentifiers) throws IOException {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (bundleIdentifiers != null) {
            int i = 0;
            while (i < bundleIdentifiers.length) {
                bundles.add(this.bundle(bundleIdentifiers[i]));
                ++i;
            }
        }
        return this.frameworkWiring.resolveBundles(bundles);
    }

    @Override
    public void restartFramework() throws IOException {
        try {
            this.bundle(0L).update();
        }
        catch (BundleException e) {
            throw new IOException("Unable to restart framework: " + (Object)((Object)e));
        }
    }

    @Override
    public void setBundleStartLevel(long bundleIdentifier, int newlevel) throws IOException {
        try {
            ((BundleStartLevel)this.bundle(bundleIdentifier).adapt(BundleStartLevel.class)).setStartLevel(newlevel);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Cannot set start level: " + e);
            iox.initCause(e);
            throw iox;
        }
    }

    @Override
    public CompositeData setBundleStartLevels(long[] bundleIdentifiers, int[] newlevels) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        if (newlevels == null) {
            throw new IOException("new start levels must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                ((BundleStartLevel)this.bundle(bundleIdentifiers[i]).adapt(BundleStartLevel.class)).setStartLevel(newlevels[i]);
            }
            catch (Throwable e) {
                return this.handleUpdateException(bundleIdentifiers, i, e);
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    @Override
    public void setFrameworkStartLevel(int newlevel) throws IOException {
        try {
            this.frameworkStartLevel.setStartLevel(newlevel, new FrameworkListener[0]);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Cannot set start level: " + e);
            iox.initCause(e);
            throw iox;
        }
    }

    @Override
    public void setInitialBundleStartLevel(int newlevel) throws IOException {
        try {
            this.frameworkStartLevel.setInitialBundleStartLevel(newlevel);
        }
        catch (Throwable e) {
            IOException iox = new IOException("Cannot set start level: " + e);
            iox.initCause(e);
            throw iox;
        }
    }

    @Override
    public void shutdownFramework() throws IOException {
        try {
            this.bundle(0L).stop();
        }
        catch (Throwable be) {
            throw new IOException("Shutting down not implemented in this framework: " + be);
        }
    }

    @Override
    public void startBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).start();
        }
        catch (Throwable e) {
            throw new IOException("Unable to start bundle: " + e);
        }
    }

    @Override
    public CompositeData startBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).start();
            }
            catch (Throwable e) {
                return this.handleUpdateException(bundleIdentifiers, i, e);
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    @Override
    public void stopBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).stop();
        }
        catch (Throwable e) {
            throw new IOException("Unable to stop bundle: " + e);
        }
    }

    @Override
    public CompositeData stopBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).stop();
            }
            catch (Throwable e) {
                return this.handleUpdateException(bundleIdentifiers, i, e);
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    @Override
    public void uninstallBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).uninstall();
        }
        catch (BundleException e) {
            throw new IOException("Unable to uninstall bundle: " + (Object)((Object)e));
        }
    }

    @Override
    public CompositeData uninstallBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).uninstall();
            }
            catch (Throwable e) {
                return this.handleUpdateException(bundleIdentifiers, i, e);
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    @Override
    public void updateBundle(long bundleIdentifier) throws IOException {
        try {
            this.bundle(bundleIdentifier).update();
        }
        catch (Throwable e) {
            throw new IOException("Unable to update bundle: " + e);
        }
    }

    @Override
    public void updateBundleFromURL(long bundleIdentifier, String url) throws IOException {
        InputStream is = null;
        try {
            try {
                is = new URL(url).openStream();
                this.bundle(bundleIdentifier).update(is);
            }
            catch (Throwable e) {
                throw new IOException("Unable to update bundle: " + e);
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public CompositeData updateBundles(long[] bundleIdentifiers) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            try {
                this.bundle(bundleIdentifiers[i]).update();
            }
            catch (Throwable e) {
                return this.handleUpdateException(bundleIdentifiers, i, e);
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    @Override
    public CompositeData updateBundlesFromURL(long[] bundleIdentifiers, String[] urls) throws IOException {
        if (bundleIdentifiers == null) {
            throw new IOException("Bundle identifiers must not be null");
        }
        int i = 0;
        while (i < bundleIdentifiers.length) {
            InputStream is = null;
            try {
                try {
                    is = new URL(urls[i]).openStream();
                    this.bundle(bundleIdentifiers[i]).update(is);
                }
                catch (Throwable e) {
                    CompositeData compositeData = this.handleUpdateException(bundleIdentifiers, i, e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return compositeData;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return new BundleBatchActionResult().asCompositeData();
    }

    private CompositeData handleUpdateException(long[] bundleIdentifiers, int currentPostion, Throwable e) {
        Long[] completed = this.convertToNonPrimativeArray(bundleIdentifiers, currentPostion);
        Long[] remaining = new Long[bundleIdentifiers.length - currentPostion - 1];
        int j = 0;
        while (j < remaining.length) {
            remaining[j] = bundleIdentifiers[currentPostion + 1 + j];
            ++j;
        }
        return new BundleBatchActionResult(e.toString(), completed, bundleIdentifiers[currentPostion], remaining).asCompositeData();
    }

    @Override
    public void updateFramework() throws IOException {
        try {
            Bundle b = this.bundle(0L);
            if (b != null) {
                b.update();
            }
        }
        catch (BundleException be) {
            throw new IOException("Update of the framework is not implemented: " + (Object)((Object)be));
        }
    }

    @Override
    public long[] getDependencyClosure(long[] bundleIdentifiers) throws IOException {
        Collection bundles = this.frameworkWiring.getDependencyClosure(this.getBundles(bundleIdentifiers));
        long[] result = new long[bundles.size()];
        int i = 0;
        for (Bundle bundle : bundles) {
            result[i++] = bundle.getBundleId();
        }
        return result;
    }

    @Override
    public String getProperty(String key) throws IOException {
        return this.bundleContext.getProperty(key);
    }

    @Override
    public long[] getRemovalPendingBundles() throws IOException {
        Collection removalPendingBundles = this.frameworkWiring.getRemovalPendingBundles();
        long[] result = new long[removalPendingBundles.size()];
        int i = 0;
        for (Bundle bundle : removalPendingBundles) {
            result[i++] = bundle.getBundleId();
        }
        return result;
    }

    @Override
    public boolean refreshBundleAndWait(long bundleIdentifier) throws IOException {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        Bundle bundle = this.bundle(bundleIdentifier);
        bundles.add(bundle);
        StandardFrameworkListener standardFrameworkListener = new StandardFrameworkListener();
        this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{standardFrameworkListener});
        standardFrameworkListener.getResult();
        return bundle.getState() >= 4;
    }

    @Override
    public CompositeData refreshBundlesAndWait(long[] bundleIdentifiers) throws IOException {
        Collection<Bundle> bundles;
        StandardFrameworkListener standardFrameworkListener = new StandardFrameworkListener();
        if (bundleIdentifiers == null) {
            bundles = Arrays.asList(this.bundleContext.getBundles());
            this.frameworkWiring.refreshBundles(null, new FrameworkListener[]{standardFrameworkListener});
        } else {
            bundles = this.getBundles(bundleIdentifiers);
            this.frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{standardFrameworkListener});
        }
        boolean operationResult = standardFrameworkListener.getResult();
        ArrayList<Long> completedBundles = new ArrayList<Long>();
        boolean result = true;
        for (Bundle bundle : bundles) {
            if (bundle.getState() >= 4) {
                completedBundles.add(bundle.getBundleId());
                continue;
            }
            result = false;
        }
        if (!operationResult) {
            result = false;
        }
        return new BundleBatchResolveResult(completedBundles.toArray(new Long[completedBundles.size()]), result).asCompositeData();
    }

    @Override
    public CompositeData resolve(long[] bundleIdentifiers) throws IOException {
        Collection<Object> bundles;
        if (bundleIdentifiers == null) {
            bundles = new HashSet();
            Bundle[] allBundles = this.bundleContext.getBundles();
            Bundle[] bundleArray = allBundles;
            int n = allBundles.length;
            int n2 = 0;
            while (n2 < n) {
                Object bundle = bundleArray[n2];
                if (bundle.getState() < 4) {
                    bundles.add(bundle);
                }
                ++n2;
            }
        } else {
            bundles = this.getBundles(bundleIdentifiers);
        }
        boolean operationResult = this.frameworkWiring.resolveBundles(bundles);
        boolean result = true;
        ArrayList<Long> completedBundles = new ArrayList<Long>();
        for (Bundle bundle : bundles) {
            if (bundle.getState() >= 4) {
                completedBundles.add(bundle.getBundleId());
                continue;
            }
            result = false;
        }
        if (!operationResult) {
            result = false;
        }
        return new BundleBatchResolveResult(completedBundles.toArray(new Long[completedBundles.size()]), result).asCompositeData();
    }

    private Collection<Bundle> getBundles(long[] bundleIdentifiers) throws IOException {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        int i = 0;
        while (i < bundleIdentifiers.length) {
            bundles.add(this.bundle(bundleIdentifiers[i]));
            ++i;
        }
        return bundles;
    }

    private Bundle bundle(long bundleIdentifier) throws IOException {
        Bundle b;
        try {
            b = this.bundleContext.getBundle(bundleIdentifier);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        if (b == null) {
            throw new IOException("Bundle <" + bundleIdentifier + "> does not exist");
        }
        return b;
    }

    private Long[] convertToNonPrimativeArray(long[] src, int length) {
        if (src == null || src.length == 0) {
            return new Long[0];
        }
        Long[] dest = new Long[length];
        int i = 0;
        while (i < length) {
            dest[i] = src[i];
            ++i;
        }
        return dest;
    }

    private static class StandardFrameworkListener
    implements FrameworkListener {
        private final Object monitor = new Object();
        private volatile boolean sucsess = false;
        private volatile boolean completed = false;

        private StandardFrameworkListener() {
        }

        public void frameworkEvent(FrameworkEvent event) {
            if (4 == event.getType()) {
                this.sucsess = true;
            } else if (2 == event.getType()) {
                this.sucsess = false;
            }
            this.completed = true;
            this.monitor.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean getResult() {
            Object object = this.monitor;
            synchronized (object) {
                while (true) {
                    if (this.completed) {
                        return this.sucsess;
                    }
                    try {
                        this.monitor.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

