/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.editor;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.etrice.core.fsm.ui.FSMUiModule;
import org.eclipse.etrice.ui.common.base.editor.IInputUriHolder;
import org.eclipse.graphiti.ui.editor.DefaultUpdateBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.editor.GFWorkspaceCommandStackImpl;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class CustomUpdateBehavior
extends DefaultUpdateBehavior {
    @Inject
    private IResourceSetProvider resourceSetProvider;

    public CustomUpdateBehavior(DiagramBehavior diagramBehavior) {
        super(diagramBehavior);
        Injector injector = FSMUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected void createEditingDomain(IDiagramEditorInput input) {
        XtextResourceSet resourceSet;
        if (this.diagramBehavior.getDiagramContainer() instanceof IInputUriHolder) {
            URI uri = ((IInputUriHolder)this.diagramBehavior.getDiagramContainer()).getInputUri();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            IProject project = file.getProject();
            resourceSet = this.resourceSetProvider.get(project);
        } else {
            resourceSet = new XtextResourceSet();
        }
        GFWorkspaceCommandStackImpl workspaceCommandStack = new GFWorkspaceCommandStackImpl((IOperationHistory)new DefaultOperationHistory());
        TransactionalEditingDomainImpl editingDomain = new TransactionalEditingDomainImpl((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (TransactionalCommandStack)workspaceCommandStack, (ResourceSet)resourceSet);
        WorkspaceEditingDomainFactory.INSTANCE.mapResourceSet((TransactionalEditingDomain)editingDomain);
        this.initializeEditingDomain((TransactionalEditingDomain)editingDomain);
    }
}

