/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.base.concurrency;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.ui.common.base.concurrency.EditingDomainAdapter;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ConcurrentModificationObserver
implements IPartListener {
    private EditingDomainAdapter.Factory factory = new EditingDomainAdapter.Factory();

    public ConcurrentModificationObserver(IWorkbenchPage activePage) {
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editor = editorRef.getEditor(false);
            if (editor != null) {
                this.partOpened((IWorkbenchPart)editor);
            }
            ++n2;
        }
    }

    public void partOpened(IWorkbenchPart part) {
        EditingDomain editingDomain;
        if (!(part instanceof DiagramEditorBase)) {
            return;
        }
        Object adapter = part.getAdapter(IEditingDomainProvider.class);
        if (adapter instanceof IEditingDomainProvider && (editingDomain = ((IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain) {
            this.factory.adapt(editingDomain, EditingDomainAdapter.class);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        EditingDomainAdapter editingDomainAdapter;
        EditingDomain editingDomain;
        if (!(part instanceof DiagramEditorBase)) {
            return;
        }
        Object adapter = part.getAdapter(IEditingDomainProvider.class);
        if (adapter instanceof IEditingDomainProvider && (editingDomain = ((IEditingDomainProvider)adapter).getEditingDomain()) instanceof TransactionalEditingDomain && (editingDomainAdapter = (EditingDomainAdapter)((Object)this.factory.adapt(editingDomain, EditingDomainAdapter.class))) != null) {
            editingDomainAdapter.dispose();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public static class Initializer
    implements IStartup {
        public void earlyStartup() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.addPartListener((IPartListener)new ConcurrentModificationObserver(activePage));
                }
            });
        }
    }
}

