/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.types;

import java.util.List;
import org.eclipse.escet.chi.codegen.java.JavaFile;
import org.eclipse.escet.chi.codegen.types.TypeID;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public abstract class ObjectTypeID
extends TypeID {
    public ObjectTypeID(boolean needsCoordinator, TypeID.TypeKind kind) {
        super(needsCoordinator, kind);
    }

    public ObjectTypeID(boolean needsCoordinator, TypeID.TypeKind kind, List<TypeID> subTypes) {
        super(needsCoordinator, kind, subTypes);
    }

    @Override
    public String getJavaType() {
        return this.getJavaClassType();
    }

    @Override
    public String getSimplestJavaValue() {
        return "null";
    }

    @Override
    public String getReadName(String stream, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        String classPath = this.getJavaClassType();
        int idx = classPath.lastIndexOf(46);
        if (idx != -1) {
            jf.addImport(classPath + ".read", true);
        }
        return Strings.fmt((String)"%s.read(chiCoordinator, %s)", (Object[])new Object[]{classPath, stream});
    }

    @Override
    public String getWriteName(String stream, String val, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        return Strings.fmt((String)"(%s).write(%s);", (Object[])new Object[]{val, stream});
    }

    @Override
    public String getToString(String val, JavaFile jf) {
        Assert.check((boolean)this.isPrintable());
        return Strings.fmt((String)"(%s).toString()", (Object[])new Object[]{val});
    }

    @Override
    public String getHashCodeName(String val, JavaFile jf) {
        return Strings.fmt((String)"(%s).hashCode()", (Object[])new Object[]{val});
    }

    @Override
    public String getEqual(String lhs, String rhs) {
        return Strings.fmt((String)"(%s).equals(%s)", (Object[])new Object[]{lhs, rhs});
    }

    @Override
    public String getUnequal(String lhs, String rhs) {
        return Strings.fmt((String)"!(%s).equals(%s)", (Object[])new Object[]{lhs, rhs});
    }

    @Override
    public String getEmptyValue(JavaFile jf) {
        String classPath = this.getJavaClassType();
        int idx = classPath.lastIndexOf(46);
        if (idx != -1) {
            jf.addImport(classPath, false);
            classPath = classPath.substring(idx + 1);
        }
        if (this.needsCoordinator) {
            return "new " + classPath + "(chiCoordinator)";
        }
        return "new " + classPath + "()";
    }
}

