/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.equinox.internal.region.BundleIdToRegionMapping;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class BundleIdBasedRegion
implements Region {
    private static final Pattern invalidName = Pattern.compile("[:=\\n*?,\"\\\\]");
    private static final String REGION_LOCATION_DELIMITER = "#";
    private static final String FILE_SCHEME = "file:";
    private final String regionName;
    private final RegionDigraph regionDigraph;
    private final BundleIdToRegionMapping bundleIdToRegionMapping;
    private final BundleContext bundleContext;
    private final ThreadLocal<Region> threadLocal;

    public BundleIdBasedRegion(String regionName, RegionDigraph regionDigraph, BundleIdToRegionMapping bundleIdToRegionMapping, BundleContext bundleContext, ThreadLocal<Region> threadLocal) {
        BundleIdBasedRegion.validateName(regionName);
        if (regionDigraph == null) {
            throw new IllegalArgumentException("The region digraph must not be null");
        }
        if (bundleIdToRegionMapping == null) {
            throw new IllegalArgumentException("The bundle id to region mapping must not be null");
        }
        this.regionName = regionName;
        this.regionDigraph = regionDigraph;
        this.bundleIdToRegionMapping = bundleIdToRegionMapping;
        this.bundleContext = bundleContext;
        this.threadLocal = threadLocal;
    }

    private static void validateName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The region name must not be null");
        }
        if (invalidName.matcher(name).find()) {
            throw new IllegalArgumentException("The region name has invalid characters: " + name);
        }
    }

    @Override
    public String getName() {
        return this.regionName;
    }

    @Override
    public void addBundle(Bundle bundle) throws BundleException {
        this.addBundle(bundle.getBundleId());
    }

    @Override
    public void addBundle(long bundleId) throws BundleException {
        this.bundleIdToRegionMapping.associateBundleWithRegion(bundleId, this);
    }

    @Override
    public Bundle installBundleAtLocation(String location, InputStream input) throws BundleException {
        return this.installBundle0(location, input, false);
    }

    @Override
    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.installBundle0(location, input, true);
    }

    private Bundle installBundle0(String location, InputStream input, boolean appendRegionName) throws BundleException {
        if (this.bundleContext == null) {
            throw new BundleException("This region is not connected to an OSGi Framework.", 2);
        }
        this.setRegionThreadLocal();
        try {
            input = this.checkFileProtocol(location, input);
            if (appendRegionName) {
                location = String.valueOf(location) + REGION_LOCATION_DELIMITER + this.regionName;
            }
            Bundle bundle = this.bundleContext.installBundle(location, input);
            return bundle;
        }
        finally {
            this.removeRegionThreadLocal();
        }
    }

    private InputStream checkFileProtocol(String location, InputStream input) throws BundleException {
        if (input != null || location.startsWith(FILE_SCHEME)) {
            return input;
        }
        try {
            return new URL(location).openStream();
        }
        catch (MalformedURLException e) {
            throw new BundleException("The location resulted in an invalid bundle URI: " + location, (Throwable)e);
        }
        catch (IOException e) {
            throw new BundleException("The location referred to an invalid bundle at URI: " + location, (Throwable)e);
        }
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    private void setRegionThreadLocal() {
        if (this.threadLocal != null) {
            this.threadLocal.set(this);
        }
    }

    private void removeRegionThreadLocal() {
        if (this.threadLocal != null) {
            this.threadLocal.remove();
        }
    }

    @Override
    public Bundle getBundle(String symbolicName, Version version) {
        if (this.bundleContext == null) {
            return null;
        }
        Set<Long> bundleIds = this.getBundleIds();
        for (long bundleId : bundleIds) {
            Bundle bundle = this.bundleContext.getBundle(bundleId);
            if (bundle == null || !symbolicName.equals(bundle.getSymbolicName()) || !version.equals((Object)bundle.getVersion())) continue;
            return bundle;
        }
        return null;
    }

    @Override
    public void connectRegion(Region headRegion, RegionFilter filter) throws BundleException {
        this.regionDigraph.connect(this, filter, headRegion);
    }

    @Override
    public boolean contains(long bundleId) {
        return this.bundleIdToRegionMapping.isBundleAssociatedWithRegion(bundleId, this);
    }

    @Override
    public boolean contains(Bundle bundle) {
        return this.contains(bundle.getBundleId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.regionName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleIdBasedRegion)) {
            return false;
        }
        BundleIdBasedRegion other = (BundleIdBasedRegion)obj;
        return this.regionName.equals(other.regionName);
    }

    @Override
    public void removeBundle(Bundle bundle) {
        this.removeBundle(bundle.getBundleId());
    }

    @Override
    public void removeBundle(long bundleId) {
        this.bundleIdToRegionMapping.dissociateBundleFromRegion(bundleId, this);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Set<Long> getBundleIds() {
        return this.bundleIdToRegionMapping.getBundleIds(this);
    }

    @Override
    public Set<RegionDigraph.FilteredRegion> getEdges() {
        return this.regionDigraph.getEdges(this);
    }

    @Override
    public void visitSubgraph(RegionDigraphVisitor visitor) {
        this.regionDigraph.visitSubgraph(this, visitor);
    }

    @Override
    public RegionDigraph getRegionDigraph() {
        return this.regionDigraph;
    }
}

