/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.test.bundle;

import java.util.Dictionary;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.service.TestConfigurationService;
import org.eclipse.soda.dk.testcontroller.service.TestControllerService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testcontroller.test.bundle.TestRunConsolePrinter;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.BundleActivator;

public class TestControllerTestBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.testcontroller.test.bundle.TestControllerTestBundle";
    public static final String[] EXPORTED_SERVICE_NAMES = BaseBundleActivator.NO_SERVICES;
    public static final String[] IMPORTED_SERVICE_NAMES = new String[]{TestControllerService.SERVICE_NAME};
    public static final int TEST_ENDED = 7100;
    public static final int TEST_ERROR = 7101;
    public static final int TEST_FAILED = 7102;
    public static final int TESTRUN_ENDED = 7103;
    public static final int TESTRUN_ERROR = 7104;
    public static final int TESTRUN_STARTED = 7105;
    public static final int TEST_STARTED = 7106;
    public static final int BUNDLE_ACTIVATED = 7107;
    public static final int TEST_INVALID_FILTER_FOUND = 7108;
    public static final int TEST_INVALID_FILTER_NOT_FOUND = 7109;
    public static final int BUNDLE_TEST_FAILED = 7110;
    public static final int BUNDLE_RETURNS = 7111;
    public static ResourceBundle DefaultResourceBundle;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.testcontroller.test.bundle.TestControllerTestBundleResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    protected void activate() {
        LogUtility.logInfo((String)DefaultResourceBundle.getString(Integer.toString(7107)));
        TestControllerService testController = (TestControllerService)this.getImportedService(TestControllerService.SERVICE_NAME);
        TestSynchronizationService syncService = null;
        String actionId = "Action1";
        try {
            TestSessionService testSession = testController.createTestSession(syncService);
            testSession.addGlobalTestRunListener((TestRunListenerService)new TestRunConsolePrinter());
            TestConfigurationService testConfigurationService = testSession.getTestConfigurationService();
            Properties props = new Properties();
            props.put("testId", "testA");
            props.put("testKey", "testValue");
            testConfigurationService.createFactoryConfiguration("org.eclipse.soda.dk.testagent.test.factory.TestAgentTestFactory", null, (Dictionary)props);
            props = new Properties();
            props.put("testId", "testB");
            props.put("testKey", "testValue");
            testConfigurationService.createFactoryConfiguration("org.eclipse.soda.dk.testagent.test.factory.TestAgentTestFactory", null, (Dictionary)props);
            testSession.runSingleTest(actionId, "TestA", "(testId=testA)", null, null, null);
            testSession.runSingleTest(actionId, "TestB", "(testId=testB)", "org.eclipse.soda.dk.testagent.test.TestAgentTest", null, null);
            testSession.runMultipleTests(actionId, "TestAandB", "(testId=*)", null, null, null);
            testSession.runSingleTest(actionId, "TestC", "(testId=testC)", null, null, null);
            testSession.runSingleTest(actionId, "TestC", "(service.pid=*)", "NonExistingClassName", null, null);
            try {
                testSession.runSingleTest(actionId, "TestC", "invalid filter", null, null, null);
                System.err.println(DefaultResourceBundle.getString(Integer.toString(7108)));
            }
            catch (Exception expectedException) {
                Object[] parms = new Object[]{expectedException.getMessage()};
                System.out.println(Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7109)), (Object[])parms));
            }
            testSession.close();
            testConfigurationService.deleteConfigurations("(service.pid=org.eclipse.soda.dk.testagent.test.factory.TestAgentTest*)");
        }
        catch (Exception e) {
            Object[] parms = new Object[]{e};
            LogUtility.logError((String)Nls.format((String)DefaultResourceBundle.getString(Integer.toString(7102)), (Object[])parms));
        }
        LogUtility.logInfo((String)DefaultResourceBundle.getString(Integer.toString(7111)));
    }

    public String[] getExportedServiceNames() {
        return EXPORTED_SERVICE_NAMES;
    }

    public String[] getImportedServiceNames() {
        return IMPORTED_SERVICE_NAMES;
    }
}

