/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testcontroller.remote.rmi.bundle;

import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.TestController;
import org.eclipse.soda.dk.testcontroller.remote.rmi.ControllerRegistry;
import org.eclipse.soda.dk.testcontroller.remote.rmi.LocateController;
import org.eclipse.soda.dk.testcontroller.remote.rmi.RemoteTestController;
import org.eclipse.soda.dk.testcontroller.remote.rmi.TestControllerSkeleton;
import org.eclipse.soda.dk.testcontroller.service.TestControllerService;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.BundleActivator;

public class RemoteTestControllerBundle
extends BaseBundleActivator
implements BundleActivator {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.testcontroller.remote.rmi.bundle.RemoteTestControllerBundle";
    public static final String[] EXPORTED_SERVICE_NAMES = BaseBundleActivator.NO_SERVICES;
    public static final String[] IMPORTED_SERVICE_NAMES = new String[]{TestControllerService.SERVICE_NAME};
    private ConfigurationService configuration = EscConfiguration.getConfiguration();
    private ControllerRegistry controllerRegistry;
    static /* synthetic */ Class class$0;

    public void activate() {
        int port = this.configuration.getInt("testcontroller.registry.port", 2099);
        try {
            this.controllerRegistry = LocateController.createRegistry((int)port);
            this.controllerRegistry.bind((RemoteTestController)new TestControllerSkeleton(this.getTestControllerService()));
        }
        catch (Exception e) {
            Object[] parms = new Object[]{Integer.toString(port), e.getMessage()};
            LogUtility.logError((String)Nls.format((String)LocateController.DefaultResourceBundle.getString(Integer.toString(7121)), (Object[])parms));
        }
    }

    public Hashtable createProperties() {
        Hashtable properties = new Hashtable(37);
        return properties;
    }

    public TestController createService() {
        return new TestController();
    }

    protected void deactivate() {
        try {
            if (this.controllerRegistry != null) {
                RemoteTestController remoteTestController = this.controllerRegistry.getTestController();
                this.controllerRegistry.unbind();
                this.controllerRegistry = null;
                if (remoteTestController != null) {
                    UnicastRemoteObject.unexportObject((Remote)remoteTestController, true);
                }
            }
        }
        catch (Exception e) {
            LogUtility.logError((String)Nls.format((String)LocateController.DefaultResourceBundle.getString(Integer.toString(7122)), (Object)e.getMessage()));
        }
    }

    public String[] getExportedServiceNames() {
        return EXPORTED_SERVICE_NAMES;
    }

    public String[] getImportedServiceNames() {
        return IMPORTED_SERVICE_NAMES;
    }

    private TestControllerService getTestControllerService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.testcontroller.service.TestControllerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TestControllerService)this.getImportedService(clazz.getName());
    }

    protected void start() throws Exception {
        this.addImportedServiceFilter(TestControllerService.SERVICE_NAME, "(!(type=remote))");
    }

    protected void stop() throws Exception {
        this.removeImportedServiceFilter(TestControllerService.SERVICE_NAME);
    }
}

