/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.sat.plugin.activator.internal.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Method
implements Comparable<Method> {
    private static final int PRIVATE_VISIBILITY = 0;
    private static final int PACKAGE_VISIBILITY = 1;
    private static final int PROTECTED_VISIBILITY = 2;
    private static final int PUBLIC_VISIBILITY = 3;
    public static final String JT_BOOLEAN = "boolean";
    public static final String JT_DOUBLE = "double";
    public static final String JT_FLOAT = "float";
    public static final String JT_INT = "int";
    public static final String JT_LONG = "long";
    public static final String JT_SHORT = "short";
    public static final String JT_VOID = "void";
    private int visibility;
    private String returnType;
    private String name;
    private List<String> declaredExceptions;
    private String contents;
    private List<Parameter> parameters;

    Method(String name) {
        this.bePrivate();
        this.setReturnType(JT_VOID);
        this.setName(name);
        this.setParameters(new ArrayList<Parameter>(8));
        this.setDeclaredExceptions(new ArrayList<String>(10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeclaredException(String declaredException) {
        List<String> list;
        List<String> list2 = list = this.getDeclaredExceptions();
        synchronized (list2) {
            boolean exists = list.contains(declaredException);
            if (exists) {
                return;
            }
            list.add(declaredException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addParameter(Parameter parameter) {
        List<Parameter> list;
        List<Parameter> list2 = list = this.getParameters();
        synchronized (list2) {
            list.add(parameter);
        }
    }

    void bePackagePrivate() {
        this.setVisibility(1);
    }

    void bePrivate() {
        this.setVisibility(0);
    }

    void beProtected() {
        this.setVisibility(2);
    }

    void bePublic() {
        this.setVisibility(3);
    }

    @Override
    public int compareTo(Method other) {
        String otherName = other.getName();
        String name = this.getName();
        int result = name.compareTo(otherName);
        return result;
    }

    String getContents() {
        return this.contents;
    }

    List<String> getDeclaredExceptions() {
        return this.declaredExceptions;
    }

    String getName() {
        return this.name;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    String getReturnType() {
        return this.returnType;
    }

    private int getVisibility() {
        return this.visibility;
    }

    boolean isPackagePrivate() {
        return this.isVisibility(1);
    }

    boolean isPrivate() {
        return this.isVisibility(0);
    }

    boolean isProtected() {
        return this.isVisibility(2);
    }

    boolean isPublic() {
        return this.isVisibility(3);
    }

    private boolean isVisibility(int queryVisibility) {
        int visibility = this.getVisibility();
        boolean result = visibility == queryVisibility;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDeclaredException(String declaredException) {
        List<String> list;
        List<String> list2 = list = this.getDeclaredExceptions();
        synchronized (list2) {
            list.remove(declaredException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeParameter(Parameter parameter) {
        List<Parameter> list;
        List<Parameter> list2 = list = this.getParameters();
        synchronized (list2) {
            list.remove(parameter);
        }
    }

    void setContents(String contents) {
        this.contents = contents;
    }

    private void setDeclaredExceptions(List<String> declaredExceptions) {
        this.declaredExceptions = declaredExceptions;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    private void setVisibility(int visibility) {
        this.visibility = visibility;
    }
}

