/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.test;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.soda.sat.core.framework.interfaces.BundleDependencyListener;
import org.eclipse.soda.sat.core.junit.internal.AbstractServiceTestCase;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecord;
import org.eclipse.soda.sat.core.record.interfaces.IImportServiceRecordOwner;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.eclipse.soda.sat.junit.util.ValueHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleDependencyManagerTestCase
extends AbstractServiceTestCase {
    private IImportServiceRecord record;
    private ValueHolder acquiredHolder;
    private ValueHolder releasedHolder;
    private BundleDependencyService bds;
    private Map bundlesMap;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.sat.core.internal.framework.bundle.test.BundleDependencyManagerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public BundleDependencyManagerTestCase(String name) {
        super(name);
    }

    private void acquireBundleDependencyService() {
        this.acquiredHolder = ValueHolder.nullValue();
        this.releasedHolder = ValueHolder.nullValue();
        FactoryUtility utility = FactoryUtility.getInstance();
        BundleContext context = this.getBundleContext();
        this.record = utility.createImportServiceRecord(context, BundleDependencyService.SERVICE_NAME, null);
        IImportServiceRecordOwner owner = this.createImportServiceRecordOwner();
        this.record.setOwner(owner);
        this.record.acquire();
        IImportServiceRecord expected = this.record;
        Object actual = this.acquiredHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        this.bds = (BundleDependencyService)this.record.getService();
    }

    private Map createBundlesMap() {
        HashMap<String, Bundle> map = new HashMap<String, Bundle>(17);
        BundleContext context = this.getBundleContext();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            String key = bundle.getSymbolicName();
            map.put(key, bundle);
            ++i;
        }
        return map;
    }

    private IImportServiceRecordOwner createImportServiceRecordOwner() {
        return new IImportServiceRecordOwner(){

            public Object getLock() {
                return this;
            }

            public void serviceAcquired(IImportServiceRecord record) {
                BundleDependencyManagerTestCase.this.acquiredHolder.setValue((Object)record);
            }

            public void serviceReleased(IImportServiceRecord record) {
                BundleDependencyManagerTestCase.this.releasedHolder.setValue((Object)record);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getBundlesMap() {
        BundleDependencyManagerTestCase bundleDependencyManagerTestCase = this;
        synchronized (bundleDependencyManagerTestCase) {
            if (this.bundlesMap == null) {
                Map map = this.createBundlesMap();
                this.setBundlesMap(map);
            }
        }
        return this.bundlesMap;
    }

    private void releaseBundleDependencyService() {
        this.bds = null;
        this.record.release();
        IImportServiceRecord expected = this.record;
        Object actual = this.releasedHolder.getValue();
        Assert.assertSame((Object)expected, (Object)actual);
        this.record = null;
        this.acquiredHolder = null;
        this.releasedHolder = null;
    }

    private void setBundlesMap(Map bundlesMap) {
        this.bundlesMap = bundlesMap;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.acquireBundleDependencyService();
    }

    protected void tearDown() throws Exception {
        this.releaseBundleDependencyService();
        super.tearDown();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test_addBundleDependencyListener() {
        BundleDependencyListener listener = new BundleDependencyListener(){

            public void registered(Bundle importer, Bundle exporter) {
            }

            public void unregistered(Bundle importer, Bundle exporter) {
            }
        };
        try {
            this.bds.addBundleDependencyListener(listener);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.bds.removeBundleDependencyListener(listener);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.bds.removeBundleDependencyListener(listener);
    }

    public void test_addUninstallableBundle() {
    }

    public void test_getAllDependentsOf() {
        BundleContext context = this.getBundleContext();
        Bundle systemBundle = context.getBundle(0L);
        List allDependentsOfSystemBundle = this.bds.getAllDependentsOf(systemBundle);
        Iterator iterator = allDependentsOfSystemBundle.iterator();
        while (iterator.hasNext()) {
            Bundle dependent = (Bundle)iterator.next();
            List allPrerequisites = this.bds.getAllPrerequisitesOf(dependent);
            boolean exists = allPrerequisites.contains(systemBundle);
            Assert.assertTrue((boolean)exists);
        }
    }

    public void test_getAllPrerequisitesOf() {
        Bundle bundle = this.getBundle();
        List allPrerequisites = this.bds.getAllPrerequisitesOf(bundle);
        Iterator iterator = allPrerequisites.iterator();
        while (iterator.hasNext()) {
            Bundle prerequisite = (Bundle)iterator.next();
            List allDependents = this.bds.getAllDependentsOf(prerequisite);
            boolean exists = allDependents.contains(bundle);
            Assert.assertTrue((boolean)exists);
        }
    }

    public void test_getBundles() {
        Map map = this.getBundlesMap();
        Collection bundles = this.bds.getBundles();
        int mapSize = map.size();
        int bundlesSize = bundles.size();
        Assert.assertEquals((int)mapSize, (int)bundlesSize);
        Set keys = map.keySet();
        Iterator iterator = keys.iterator();
        boolean match = true;
        while (match && iterator.hasNext()) {
            Object key = iterator.next();
            Object bundle = map.get(key);
            match = bundles.contains(bundle);
        }
        if (match) {
            return;
        }
        Assert.fail((String)"The lists of the bundles do not match");
    }

    public void test_getDependentsOf() {
        BundleContext context = this.getBundleContext();
        Bundle systemBundle = context.getBundle(0L);
        List dependentsOfSystemBundle = this.bds.getDependentsOf(systemBundle);
        Iterator iterator = dependentsOfSystemBundle.iterator();
        while (iterator.hasNext()) {
            Bundle dependent = (Bundle)iterator.next();
            List prerequisites = this.bds.getPrerequisitesOf(dependent);
            boolean exists = prerequisites.contains(systemBundle);
            Assert.assertTrue((boolean)exists);
        }
    }

    public void test_getPrerequisitesOf() {
        Bundle bundle = this.getBundle();
        List prerequisites = this.bds.getPrerequisitesOf(bundle);
        Iterator iterator = prerequisites.iterator();
        while (iterator.hasNext()) {
            Bundle prerequisite = (Bundle)iterator.next();
            List dependents = this.bds.getDependentsOf(prerequisite);
            boolean exists = dependents.contains(bundle);
            Assert.assertTrue((boolean)exists);
        }
    }

    public void test_isRegisteredAsUninstallable() {
    }

    public void test_removeBundleDependencyListener() {
    }

    public void test_removeUninstallableBundle() {
    }

    public void test_toXml() {
    }
}

