/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.udp.server.multiplex.connection;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.soda.dk.connection.service.ConnectionService;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.core.service.ConfigurationService;
import org.eclipse.soda.dk.multiplex.connection.service.MultiplexConnectionListener;
import org.eclipse.soda.dk.udp.multiplex.connection.RemoteAddress;
import org.eclipse.soda.dk.udp.multiplex.connection.UdpChannelBinding;
import org.eclipse.soda.dk.udp.multiplex.connection.UdpMultiplexConnection;
import org.eclipse.soda.dk.udp.server.multiplex.connection.service.UdpServerMultiplexConnectionService;

public class UdpServerMultiplexConnection
extends UdpMultiplexConnection
implements ConnectionService,
UdpServerMultiplexConnectionService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.udp.server.multiplex.connection.UdpServerMultiplexConnection";
    protected static final char[] TOSTRING_NAME = "UdpServerMultiplexConnection[".toCharArray();

    public UdpServerMultiplexConnection(ConfigurationService configuration) {
        super(configuration);
    }

    public UdpServerMultiplexConnection(Dictionary properties) {
        this((ConfigurationService)new EscConfiguration(properties));
    }

    public UdpServerMultiplexConnection(String localhost, int localport, int maxchannels, int readsize, int writesize) throws IllegalArgumentException {
        Hashtable<String, Object> table = new Hashtable<String, Object>(23);
        if (localhost != null && !"0.0.0.0".equals(localhost)) {
            table.put("localhost", localhost);
        }
        table.put("localport", UdpServerMultiplexConnection.createInteger((int)localport));
        if (maxchannels != -1) {
            table.put("maxchannels", UdpServerMultiplexConnection.createInteger((int)maxchannels));
        }
        if (readsize != -1) {
            table.put("readsize", UdpServerMultiplexConnection.createInteger((int)readsize));
        }
        if (writesize != -1) {
            table.put("writesize", UdpServerMultiplexConnection.createInteger((int)writesize));
        }
        this.setConfigurationService((ConfigurationService)new EscConfiguration(table));
    }

    public UdpServerMultiplexConnection(int localPort) {
        this(null, localPort);
    }

    public UdpServerMultiplexConnection(String localHost, int localPort) {
        this(localHost, localPort, -1);
    }

    public UdpServerMultiplexConnection(String localHost, int localPort, int maxChannels) {
        this(localHost, localPort, maxChannels, -1, -1);
    }

    protected UdpChannelBinding processAccept(MultiplexConnectionListener listener, RemoteAddress remoteAddress) {
        int maxChannels = this.getInt("maxchannels", -1);
        if (maxChannels == -1 || this.getChannels().size() < maxChannels) {
            UdpChannelBinding channel = this.createChannel(this.createChannelId());
            channel.setRemoteAddress(remoteAddress);
            channel.setReconnectable(false);
            channel.open();
            return channel;
        }
        return null;
    }
}

