/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.ChannelState;
import org.eclipse.soda.dk.transport.HistoryQueue;
import org.eclipse.soda.dk.transport.Transport;
import org.eclipse.soda.dk.transport.TransportInputThreadMaster;
import org.eclipse.soda.dk.transport.service.ChannelStateService;

public class ThreadTransport
extends Transport
implements Runnable {
    private boolean running;
    private Thread thread;

    protected ChannelStateService createChannelState(ChannelService channel) {
        return new ChannelState(channel, this.getBufferSize());
    }

    public int getBufferSize() {
        return 2048;
    }

    public long getShutdownTimeout() {
        return 10000L;
    }

    public Thread getThread() {
        return this.thread;
    }

    public void handleNoData() {
        this.setReceivingInput(false);
    }

    public void handleNoInput() {
        this.setReceivingInput(false);
    }

    public boolean isRunning() {
        return this.running && this.getState() > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processInput() throws Exception {
        if (this.isMultiplexing()) {
            while (this.isRunning()) {
                if (this.getState() < 3) {
                    return;
                }
                this.processEvents();
            }
            return;
        }
        ChannelStateService channelState = this.getController().getChannelState(null);
        byte[] buffer = channelState.getBuffer();
        int maxlength = buffer.length;
        byte[] data = new byte[maxlength];
        int offset = channelState.getOffset();
        int bytesRead = 0;
        int inputProcessed = 0;
        while (this.isRunning()) {
            Object var10_11;
            block15: {
                block16: {
                    if (this.getState() < 3) {
                        return;
                    }
                    try {
                        try {
                            bytesRead = this.read(buffer, offset, maxlength - offset);
                            if (bytesRead > 0) {
                                HistoryQueue historyQueue = this.getHistory();
                                if (historyQueue != null) {
                                    int length = Math.min(bytesRead, data.length);
                                    System.arraycopy(buffer, offset, data, 0, length);
                                    this.addHistory(ThreadTransport.createInteger((int)bytesRead), data);
                                }
                                this.setReceivingInput();
                                inputProcessed = this.processInput(null, buffer, offset += bytesRead);
                                if (inputProcessed > 0 && (offset -= inputProcessed) > 0) {
                                    System.arraycopy(buffer, inputProcessed, buffer, 0, offset);
                                }
                                if (offset >= maxlength) {
                                    byte[] newBuffer = new byte[maxlength <<= 1];
                                    System.arraycopy(buffer, 0, newBuffer, 0, offset);
                                    buffer = newBuffer;
                                    channelState.setBuffer(newBuffer);
                                    data = new byte[maxlength];
                                }
                                break block15;
                            }
                            if (bytesRead == -1) {
                                var10_11 = null;
                                break block16;
                            }
                            this.handleNoInput();
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            bytesRead = 0;
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        var10_11 = null;
                        channelState.setOffset(offset);
                        throw throwable;
                    }
                }
                channelState.setOffset(offset);
                return;
            }
            var10_11 = null;
            channelState.setOffset(offset);
        }
    }

    protected int processInput(byte[] bytes, int length) throws Exception {
        int i = 0;
        while (i < length) {
            this.processInput(bytes[i] & 0xFF);
            ++i;
        }
        return length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processInput(ChannelService channel) throws Exception {
        int offset;
        ChannelStateService channelState;
        block10: {
            block9: {
                channelState = this.getController().getChannelState(channel);
                if (channelState == null) return;
                byte[] buffer = channelState.getBuffer();
                int maxlength = buffer.length;
                byte[] data = new byte[maxlength];
                offset = channelState.getOffset();
                int bytesRead = 0;
                int inputProcessed = 0;
                try {
                    try {
                        do {
                            if ((bytesRead = this.read(channel, buffer, offset, maxlength - offset)) > 0) {
                                HistoryQueue historyQueue = this.getHistory();
                                if (historyQueue != null) {
                                    int length = Math.min(bytesRead, data.length);
                                    System.arraycopy(buffer, offset, data, 0, length);
                                    this.addHistory(ThreadTransport.createInteger((int)bytesRead), data);
                                }
                                this.setReceivingInput();
                                inputProcessed = this.processInput(channel, buffer, offset += bytesRead);
                                if (inputProcessed > 0 && (offset -= inputProcessed) > 0) {
                                    System.arraycopy(buffer, inputProcessed, buffer, 0, offset);
                                }
                                if (offset < maxlength) continue;
                                byte[] newBuffer = new byte[maxlength <<= 1];
                                System.arraycopy(buffer, 0, newBuffer, 0, offset);
                                buffer = newBuffer;
                                channelState.setBuffer(newBuffer);
                                data = new byte[maxlength];
                                continue;
                            }
                            if (bytesRead != -1) continue;
                            Object var11_12 = null;
                            break block9;
                        } while (bytesRead > 0);
                    }
                    catch (InterruptedIOException interruptedIOException) {}
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    channelState.setOffset(offset);
                    throw throwable;
                }
            }
            channelState.setOffset(offset);
            return;
        }
        Object var11_14 = null;
        channelState.setOffset(offset);
    }

    protected int processInput(ChannelService channel, byte[] bytes, int length) throws Exception {
        if (channel == null) {
            return this.processInput(bytes, length);
        }
        int i = 0;
        while (i < length) {
            this.processInput(channel, bytes[i] & 0xFF);
            ++i;
        }
        return length;
    }

    protected void processInput(ChannelService channel, int value) throws IOException {
    }

    protected void processInput(int value) throws Exception {
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.start(true);
        ** GOTO lbl30
        {
            this.waitStateChange();
            do {
                if (this.isRunning() && this.getState() < 3) continue block2;
                try {
                    if (this.isRunning()) {
                        this.processInput();
                    }
                }
                catch (Exception exception) {
                    controller = this.getController();
                    channelState = controller.getChannelState(null);
                    controller.closeTransportChannel(channelState, true);
                    this.handleError(exception, 2013);
                }
                if (!this.isRunning()) continue;
                retryTime = this.getRetryTime();
                if (retryTime > 0L) {
                    currentState = this.getState();
                    newState = this.waitStateChange(retryTime);
                    if (this.isRunning()) {
                        if (currentState == newState) {
                            this.restart();
                        } else {
                            this.restart();
                        }
                    }
                    this.waitStateChange(retryTime);
                    continue;
                }
                this.setRunning(false);
lbl30:
                // 4 sources

            } while (this.isRunning());
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public void shutdown(boolean output) {
        this.closeChannels();
        this.setRunning(false);
        try {
            Thread thread = this.getThread();
            if (thread != null) {
                thread.interrupt();
                thread.join(this.getShutdownTimeout());
            }
        }
        catch (InterruptedException exception) {
            this.handleError(exception, 2011);
        }
        this.setThread(null);
        if (this.getState() > 3) {
            this.setState(3);
        }
        super.shutdown(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.getThread() == null) {
            ThreadTransport threadTransport = this;
            synchronized (threadTransport) {
                this.setup();
                this.setupCustom();
                String outputName = this.getOutputName();
                int length = outputName.length();
                char[] chars = new char[length + 1];
                chars[0] = 105;
                System.arraycopy(outputName.toCharArray(), 0, chars, 1, length);
                ThreadGroup threadGroup = TransportInputThreadMaster.getThreadGroupInstance();
                Thread thread = new Thread(threadGroup, this, new String(chars));
                thread.setDaemon(true);
                this.setThread(thread);
                thread.setPriority(this.getPriority());
                this.setRunning(true);
                thread.start();
            }
            this.waitStateChange(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ThreadTransport threadTransport = this;
        synchronized (threadTransport) {
            try {
                super.stop();
                this.setRunning(false);
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.interrupt();
                    thread.join(this.getShutdownTimeout());
                }
            }
            catch (RuntimeException exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            catch (InterruptedException exception) {
                EscObject.handleStaticException((Throwable)exception);
            }
            this.setThread(null);
        }
    }
}

