/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.transport;

import org.eclipse.soda.dk.message.Message;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.transport.ConnectionTransport;
import org.eclipse.soda.dk.transport.ResponseChannelState;
import org.eclipse.soda.dk.transport.SendData;
import org.eclipse.soda.dk.transport.service.ChannelStateService;
import org.eclipse.soda.dk.transport.service.ControllerService;
import org.eclipse.soda.dk.transport.service.ResponseListener;
import org.eclipse.soda.dk.transport.service.SendDataService;
import org.eclipse.soda.dk.transport.service.TransportService;

public abstract class ResponseTransport
extends ConnectionTransport {
    public static final int NO_RESPONSE_STATUS_UNKNOWN = 0;
    public static final int NO_RESPONSE_STATUS_MESSAGE_RESENT = 1;
    public static final int NO_RESPONSE_STATUS_ERROR = 2;
    private long responseMessageCount = 0L;
    protected MessageService sentMessage = null;
    private long responseTimeout = 0L;
    private byte[] lastWriteBytes = null;
    protected final Object readBlock = new Object();

    protected ResponseTransport() {
    }

    protected ChannelStateService createChannelState(ChannelService channel) {
        return new ResponseChannelState(channel, this.getBufferSize());
    }

    public void fireMessageReceived(ChannelService channel, Object timestamp, MessageService message) {
        this.responseReceived(channel, timestamp);
        super.fireMessageReceived(channel, timestamp, message);
    }

    public void fireMessageReceived(Object timestamp, MessageService message) {
        this.responseReceived(null, timestamp);
        super.fireMessageReceived(timestamp, message);
    }

    public void fireMessageReceivedNoResponse(ChannelService channel, Object timestamp, MessageService message) {
        super.fireMessageReceived(channel, timestamp, message);
    }

    public void fireMessageReceivedNoResponse(Object timestamp, MessageService message) {
        Object currentTimestamp = timestamp != null ? timestamp : ResponseTransport.getCurrentTimestamp();
        this.getController().messageReceived((TransportService)this, currentTimestamp, null, message);
        this.addHistory(currentTimestamp, message);
    }

    public long getDefaultResponseTimeout() {
        return 1000L;
    }

    protected byte[] getLastWriteBytes() {
        return this.lastWriteBytes;
    }

    public long getResponseMessageCount() {
        return this.responseMessageCount;
    }

    public long getResponseTimeout() {
        return this.responseTimeout;
    }

    public MessageService getSentMessage() {
        return this.sentMessage;
    }

    public long getShutdownTimeout() {
        return this.getResponseTimeout() << 1;
    }

    public int noResponseProcessing(ChannelService channel) {
        ControllerService controller = this.getController();
        ChannelStateService channelState = controller.getChannelState(channel);
        if (channelState != null && channelState.incrementRetryCount() < this.getTransmitRetries()) {
            SendDataService sendData = channelState.getLastSendData();
            try {
                this.writeRaw(channel, sendData.getBytes());
                channelState.setState(3);
                controller.scheduleTimeout(channelState, null, this.getResponseTimeout());
                return 1;
            }
            catch (Exception exception) {
                ResponseListener responseListener = sendData.getResponseListener();
                if (responseListener != null) {
                    responseListener.noResponseReceived((TransportService)this, channel, ResponseTransport.getCurrentTimestamp(), sendData.getData());
                }
                return 2;
            }
        }
        return 2;
    }

    public void responseReceived() {
        this.responseReceived(null, ResponseTransport.getCurrentTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(ChannelService channel, Object timestamp) {
        ControllerService controller;
        ChannelStateService channelState;
        this.updateResponseMessageCount();
        if (this.getResponseTimeout() > 0L && (channelState = (controller = this.getController()).getChannelState(channel)) != null) {
            byte[] sendBytes = null;
            ChannelStateService channelStateService = channelState;
            synchronized (channelStateService) {
                SendDataService nextSendData = null;
                int state = channelState.getState();
                if (state == 3 || state == 5 || state == 1) {
                    SendDataService sendData = channelState.getLastSendData();
                    ResponseListener responseListener = sendData.getResponseListener();
                    if (responseListener != null && !this.isEcho()) {
                        responseListener.responseReceived((TransportService)this, channel, timestamp != null ? timestamp : ResponseTransport.getCurrentTimestamp(), sendData.getData());
                    }
                    if ((nextSendData = channelState.getNextSendData()) == null && (state == 3 || state == 1)) {
                        channelState.setState(0);
                        controller.scheduleTimeout(channelState, null, this.getNoActivityTimeout());
                    }
                } else {
                    nextSendData = channelState.getNextSendData();
                }
                channelState.decrementPendingResponseCount();
                if (nextSendData == null) {
                    if (state == 5) {
                        controller.closeTransportChannel(channelState, false);
                    }
                } else {
                    channelState.setLastSendData(nextSendData);
                    channelState.setRetryCount(0);
                    sendBytes = nextSendData.getBytes();
                    channelState.incrementPendingResponseCount();
                    if (state != 5) {
                        channelState.setState(3);
                    }
                    controller.scheduleTimeout(channelState, null, this.getResponseTimeout());
                }
            }
            if (sendBytes != null) {
                try {
                    if (channel != null) {
                        this.write(channel, sendBytes, -1L);
                    } else {
                        this.write(sendBytes, -1L);
                    }
                }
                catch (Exception exception) {
                    this.handleError(exception, 2030, new Message(sendBytes), this.getHistory());
                }
            }
        }
    }

    protected void setLastWriteBytes(byte[] lastWriteBytes) {
        this.lastWriteBytes = lastWriteBytes;
    }

    public void setResponseMessageCount(long responseMessageCount) {
        this.responseMessageCount = responseMessageCount;
    }

    public void setResponseTimeout(long responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setSentMessage(MessageService sentMessage) {
        this.sentMessage = sentMessage;
    }

    public void setup() {
        super.setup();
        if (this.getResponseTimeout() == 0L) {
            this.setResponseTimeout(this.getDefaultResponseTimeout());
        }
        if (this.getTransmitRetries() == 0) {
            this.setTransmitRetries(this.getDefaultTransmitRetries());
        }
    }

    public long updateResponseMessageCount() {
        return this.responseMessageCount++;
    }

    public void write(byte[] sendBytes) throws Exception {
        this.write(sendBytes, null);
    }

    protected void write(byte[] sendBytes, long responseTimeout) throws Exception {
        this.write(null, sendBytes, responseTimeout);
    }

    protected void write(byte[] sendBytes, ResponseListener responseListener) throws Exception {
        this.write(null, sendBytes, responseListener);
    }

    public void write(ChannelService channel, byte[] sendBytes) throws Exception {
        this.write(channel, sendBytes, null);
    }

    public void write(ChannelService channel, byte[] sendBytes, long responseTimeout) throws Exception {
        if (responseTimeout <= 0L) {
            this.writeRaw(channel, sendBytes);
        } else {
            this.write(channel, sendBytes, responseTimeout, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(ChannelService channel, byte[] sendBytes, long responseTimeout, ResponseListener responseListener) throws Exception {
        ControllerService controller;
        ChannelStateService channelState;
        if (!(channel == null && this.isMultiplexing() || (channelState = (controller = this.getController()).getChannelState(channel)) == null)) {
            SendData sendData = new SendData(sendBytes, responseListener);
            ChannelStateService channelStateService = channelState;
            synchronized (channelStateService) {
                if (channelState.getState() < 5) {
                    if (channelState.getPendingResponseCount() == 0) {
                        channelState.setLastSendData((SendDataService)sendData);
                        channelState.setRetryCount(0);
                        if (channel == null) {
                            this.write(sendBytes, -1L);
                        } else {
                            this.write(channel, sendBytes, -1L);
                        }
                        if (this.getResponseTimeout() > 0L) {
                            channelState.incrementPendingResponseCount();
                            channelState.setState(3);
                            controller.scheduleTimeout(channelState, null, this.getResponseTimeout());
                        } else {
                            responseListener.responseReceived((TransportService)this, channel, ResponseTransport.getCurrentTimestamp(), (Object)sendBytes);
                        }
                    } else {
                        channelState.addSendData((SendDataService)sendData);
                    }
                }
            }
        }
    }

    protected void write(ChannelService channel, byte[] sendBytes, ResponseListener responseListener) throws Exception {
        this.write(channel, sendBytes, this.getResponseTimeout(), responseListener);
    }

    protected void write(ChannelService channel, MessageService message) throws Exception {
        this.write(channel, message, null);
    }

    protected void write(ChannelService channel, MessageService message, ResponseListener responseListener) throws Exception {
        this.write(channel, message.getBytes(), responseListener);
    }

    protected void write(MessageService message) throws Exception {
        this.write(message, null);
    }

    protected void write(MessageService message, ResponseListener responseListener) throws Exception {
        this.write(null, message, responseListener);
    }

    protected void writeRaw(byte[] sendBytes) throws Exception {
        this.getConnection().write(sendBytes);
        this.addHistory(ResponseTransport.createInteger((int)(-sendBytes.length)), sendBytes);
    }

    protected void writeRaw(ChannelService channel, byte[] sendBytes) throws Exception {
        if (channel == null) {
            this.writeRaw(sendBytes);
        } else {
            this.getMultiplexConnection().write(channel, sendBytes);
            this.addHistory(ResponseTransport.createInteger((int)(-sendBytes.length)), sendBytes);
        }
    }
}

