/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.ActionContainer;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.AbstractAction;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.action.TestTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.eclipse.soda.dk.testmanager.service.TestStatisticsService;
import org.eclipse.soda.sat.core.util.LogUtility;
import org.osgi.framework.InvalidSyntaxException;

public abstract class TestAction
extends AbstractAction
implements ActionContainer {
    private List testTemplatesAndActions = new ArrayList();

    protected TestAction(String id) {
        super(id);
    }

    public void add(Action action) {
        this.testTemplatesAndActions.add(action);
        action.setParentAction(this);
    }

    public void addCounts(TestStatisticsService testStatistics) {
        Iterator iterator = this.getTestTemplatesAndActions().iterator();
        while (iterator.hasNext()) {
            Object templateOrAction = iterator.next();
            if (templateOrAction instanceof TestTemplate) {
                testStatistics.incrementCount("TEST_COUNT", 1);
                continue;
            }
            Action action = (Action)templateOrAction;
            action.addCounts(testStatistics);
        }
    }

    public void addTest(String id, String controllerId, String filter, String className, String match, Dictionary properties) {
        TestTemplate template = new TestTemplate(this, id, controllerId, filter, className, match, properties);
        this.testTemplatesAndActions.add(template);
    }

    protected abstract void execute(TestScriptService var1, TestTemplate var2) throws InvalidSyntaxException, IOException, InterruptedException;

    protected void executeTemplateOrAction(TestScriptService testScript, Object templateOrAction) throws InterruptedException {
        TestStatisticsService testStatistics = testScript.getTestStatistics();
        if (templateOrAction instanceof TestTemplate) {
            TestTemplate template = (TestTemplate)templateOrAction;
            try {
                this.execute(testScript, template);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                String filter = template.getFilter();
                Object[] parms = new Object[]{filter};
                LogUtility.logError((String)Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                testScript.getScriptListener().scriptActionError(this.getId(), this.getDescription(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7162)), (Object[])parms));
                testStatistics.incrementCount("TEST_ERROR_COUNT", 1);
            }
            catch (IOException exception) {
                LogUtility.logError((Object)this, (String)TestManager.DefaultResourceBundle.getString(Integer.toString(7163)), (Throwable)exception);
                testScript.getScriptListener().scriptActionError(this.getId(), this.getDescription(), TestManager.DefaultResourceBundle.getString(Integer.toString(7163)));
                testStatistics.incrementCount("TEST_ERROR_COUNT", 1);
            }
        } else {
            TestAction.execute(testScript, (Action)templateOrAction);
        }
    }

    public String getDescription() {
        return String.valueOf(this.getName()) + TestManager.DefaultResourceBundle.getString(Integer.toString(7164));
    }

    protected String getMatchDescription(String filter, String className) {
        String description = null;
        if (filter != null) {
            description = filter;
        }
        if (className != null) {
            description = description == null ? className : String.valueOf(description) + " (" + className + ')';
        }
        return description;
    }

    protected abstract String getName();

    protected TestSessionService getTestSession(TestScriptService testScript, String controllerId) throws IOException {
        TestSessionService testSession = testScript.getDistributedTestSession().getTestSession(controllerId);
        if (testSession == null) {
            String detail = controllerId == null ? TestManager.DefaultResourceBundle.getString(Integer.toString(7198)) : Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7199)), (Object)controllerId);
            this.handleScriptActionError(testScript, detail);
        }
        return testSession;
    }

    protected List getTestTemplatesAndActions() {
        return this.testTemplatesAndActions;
    }
}

