/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import java.io.IOException;
import java.util.Dictionary;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testcontroller.service.TestConfigurationService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.ConfigurationAction;
import org.eclipse.soda.dk.testmanager.action.ConfigurationTemplate;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;
import org.osgi.framework.InvalidSyntaxException;

public class CreateOrUpdateRequest
extends ConfigurationAction {
    public CreateOrUpdateRequest(String id) {
        super(id);
    }

    protected void execute(TestScriptService testScript, ConfigurationTemplate template) throws InvalidSyntaxException, IOException {
        String controllerId = template.getControllerId();
        String pid = template.getPid();
        String factoryPid = template.getFactoryPid();
        String bundleLocation = template.getBundleLocation();
        String filter = template.getFilter();
        Dictionary properties = template.getProperties();
        TestSessionService testSession = this.getTestSession(testScript, controllerId);
        if (testSession != null) {
            TestConfigurationService configurationService = testSession.getTestConfigurationService();
            if (pid != null) {
                Object[] parms = new Object[]{pid};
                testScript.getScriptListener().scriptActionInfo(this.getId(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7168)), (Object[])parms));
                configurationService.createOrUpdateConfiguration(pid, bundleLocation, properties);
            } else if (filter != null) {
                Object[] parms = new Object[]{filter};
                testScript.getScriptListener().scriptActionInfo(this.getId(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7165)), (Object[])parms));
                configurationService.updateConfigurations(filter, properties);
            } else if (factoryPid != null) {
                Object[] parms = new Object[]{factoryPid};
                testScript.getScriptListener().scriptActionInfo(this.getId(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7166)), (Object[])parms));
                configurationService.createFactoryConfiguration(factoryPid, bundleLocation, properties);
            } else {
                this.handleScriptActionError(testScript, TestManager.DefaultResourceBundle.getString(Integer.toString(7190)));
            }
        }
    }

    protected String getName() {
        return TestManager.DefaultResourceBundle.getString(Integer.toString(7167));
    }
}

