/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.action;

import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.testmanager.TestManager;
import org.eclipse.soda.dk.testmanager.action.Action;
import org.eclipse.soda.dk.testmanager.service.ScriptRunListenerService;
import org.eclipse.soda.dk.testmanager.service.TestScriptService;

public abstract class AbstractAction
implements Action {
    private String id;
    private Action parentAction;

    protected AbstractAction(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void execute(TestScriptService testScript, Action action) throws InterruptedException {
        ScriptRunListenerService scriptListener = testScript.getScriptListener();
        Action parentAction = action.getParentAction();
        String parentActionId = parentAction == null ? null : parentAction.getId();
        scriptListener.scriptActionStarted(parentActionId, action.getId(), action.getDescription());
        try {
            action.execute(testScript);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            scriptListener.scriptActionEnded(action.getId(), action.getDescription());
            throw throwable;
        }
        {
            Object var5_7 = null;
            scriptListener.scriptActionEnded(action.getId(), action.getDescription());
            return;
        }
    }

    public String getId() {
        return this.id;
    }

    public Action getParentAction() {
        return this.parentAction;
    }

    protected void handleScriptActionError(TestScriptService testScript, String detail) {
        Object[] parms = new Object[]{this.getDescription()};
        testScript.getScriptListener().scriptActionError(this.getId(), Nls.format((String)TestManager.DefaultResourceBundle.getString(Integer.toString(7194)), (Object[])parms), detail);
    }

    public void setParentAction(Action parentAction) {
        this.parentAction = parentAction;
    }
}

