/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.testagent.service.TestSynchronizationService;
import org.eclipse.soda.dk.testcontroller.service.ControllerLocaterService;
import org.eclipse.soda.dk.testcontroller.service.TestControllerService;
import org.eclipse.soda.dk.testcontroller.service.TestRunListenerService;
import org.eclipse.soda.dk.testcontroller.service.TestSessionService;
import org.eclipse.soda.dk.testmanager.service.DistributedTestSessionService;

public class DistributedTestSession
implements DistributedTestSessionService {
    private Map testSessions;
    private List remoteControllerLocaters;
    private TestSynchronizationService syncService;
    private TestRunListenerService globalRunListener;
    private boolean interrupted;
    private ControllerLocaterService localControllerLocater;

    public DistributedTestSession(ControllerLocaterService localControllerLocater, List remoteControllerLocaters, TestSynchronizationService syncService, TestRunListenerService globalRunListener) {
        this.localControllerLocater = localControllerLocater;
        this.remoteControllerLocaters = remoteControllerLocaters;
        this.syncService = syncService;
        this.globalRunListener = globalRunListener;
        this.testSessions = new Hashtable();
    }

    public void close() {
        Iterator iter = this.testSessions.values().iterator();
        while (iter.hasNext()) {
            TestSessionService testSession = (TestSessionService)iter.next();
            try {
                testSession.close();
            }
            catch (IOException iOException) {}
            iter.remove();
        }
    }

    public synchronized TestSessionService getTestSession(String controllerId) throws IOException {
        String nonNullControllerId = String.valueOf(controllerId);
        TestSessionService testSession = (TestSessionService)this.testSessions.get(nonNullControllerId);
        if (testSession == null) {
            TestControllerService testController = null;
            Iterator iterator = this.remoteControllerLocaters.iterator();
            while (testController == null && iterator.hasNext()) {
                ControllerLocaterService controllerLocater = (ControllerLocaterService)iterator.next();
                testController = controllerLocater.findController(controllerId);
            }
            if (testController == null) {
                testController = this.localControllerLocater.findController(controllerId);
            }
            if (testController != null) {
                testSession = testController.createTestSession(this.syncService);
                testSession.addGlobalTestRunListener(this.globalRunListener);
                this.testSessions.put(nonNullControllerId, testSession);
                return testSession;
            }
        }
        return testSession;
    }

    public void interrupt() {
        Iterator iter = this.testSessions.values().iterator();
        while (iter.hasNext()) {
            TestSessionService testSession = (TestSessionService)iter.next();
            try {
                testSession.interrupt();
            }
            catch (IOException iOException) {}
        }
        this.interrupted = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }
}

