/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.testmanager.bundle;

import org.eclipse.soda.dk.testcontroller.service.ControllerLocaterService;
import org.eclipse.soda.dk.testmanager.service.TestManagerService;
import org.eclipse.soda.sat.core.record.interfaces.IServiceDetecter;
import org.eclipse.soda.sat.core.record.interfaces.ServiceDetecterListener;
import org.eclipse.soda.sat.core.util.FactoryUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ControllerLocaterDetecter {
    private TestManagerService testManager;
    private IServiceDetecter detecter;
    private ServiceDetecterListener detecterListener;

    public ControllerLocaterDetecter(TestManagerService testManager) {
        this.testManager = testManager;
    }

    public void activate(BundleContext bundleContext) {
        FactoryUtility util = FactoryUtility.getInstance();
        this.detecter = util.createServiceDetecter(bundleContext, ControllerLocaterService.SERVICE_NAME);
        this.detecterListener = new ServiceDetecterListener(){

            public void serviceAdded(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                ControllerLocaterDetecter.this.getTestManager().addRemoteControllerLocater((ControllerLocaterService)service);
            }

            public void serviceRemoved(IServiceDetecter detecter, ServiceReference serviceReference, Object service) {
                ControllerLocaterDetecter.this.getTestManager().removeRemoteControllerLocater((ControllerLocaterService)service);
            }
        };
        this.detecter.addServiceDetecterListener(this.detecterListener);
        this.detecter.acquire();
    }

    public void deactivate() {
        this.detecter.release();
        this.detecter.removeServiceDetecterListener(this.detecterListener);
        this.detecter = null;
    }

    protected TestManagerService getTestManager() {
        return this.testManager;
    }
}

